/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.processor.impl.DefaultContextualErrorHandler;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.junit.Before;
import org.junit.Test;

public class DefaultContextualErrorHandlerTest {
    private final List<Object> mocks = new ArrayList<Object>();
    private ErrorHandler errorHandlerMock;
    private ElasticsearchWork<?> work1;
    private ElasticsearchWork<?> work2;
    private ElasticsearchWork<?> work3;
    private LuceneWork luceneWork1;
    private LuceneWork luceneWork2;
    private LuceneWork luceneWork3;

    @Before
    public void initMocks() {
        this.errorHandlerMock = (ErrorHandler)EasyMock.createStrictMock(ErrorHandler.class);
        this.mocks.add(this.errorHandlerMock);
        this.work1 = this.work(1);
        this.work2 = this.work(2);
        this.work3 = this.work(3);
        this.luceneWork1 = this.luceneWork(1);
        this.luceneWork2 = this.luceneWork(2);
        this.luceneWork3 = this.luceneWork(3);
    }

    @Test
    public void singleError() {
        Capture capture = new Capture();
        this.replay();
        DefaultContextualErrorHandler handler = new DefaultContextualErrorHandler(this.errorHandlerMock);
        this.verify();
        Throwable throwable = new Throwable();
        this.reset();
        EasyMock.expect((Object)this.work1.getLuceneWork()).andReturn((Object)this.luceneWork1);
        EasyMock.expect((Object)this.work2.getLuceneWork()).andReturn((Object)this.luceneWork2);
        EasyMock.expect((Object)this.work3.getLuceneWork()).andReturn((Object)this.luceneWork3);
        this.replay();
        handler.markAsFailed(this.work1, throwable);
        handler.markAsSkipped(this.work2);
        handler.markAsSkipped(this.work3);
        this.verify();
        this.reset();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        this.replay();
        handler.handle();
        this.verify();
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isSameAs((Object)throwable);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork1);
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly((Object[])new LuceneWork[]{this.luceneWork1, this.luceneWork2, this.luceneWork3});
    }

    @Test
    public void noError() {
        this.replay();
        DefaultContextualErrorHandler handler = new DefaultContextualErrorHandler(this.errorHandlerMock);
        this.verify();
        this.reset();
        this.replay();
        handler.handle();
        this.verify();
    }

    @Test
    public void nonWorkError() {
        Capture capture = new Capture();
        this.replay();
        DefaultContextualErrorHandler handler = new DefaultContextualErrorHandler(this.errorHandlerMock);
        this.verify();
        Throwable throwable = new Throwable();
        this.reset();
        EasyMock.expect((Object)this.work1.getLuceneWork()).andReturn((Object)this.luceneWork1);
        EasyMock.expect((Object)this.work2.getLuceneWork()).andReturn((Object)this.luceneWork2);
        EasyMock.expect((Object)this.work3.getLuceneWork()).andReturn((Object)this.luceneWork3);
        this.replay();
        handler.markAsSkipped(this.work1);
        handler.markAsSkipped(this.work2);
        handler.markAsSkipped(this.work3);
        this.verify();
        this.reset();
        this.replay();
        handler.addThrowable(throwable);
        this.verify();
        this.reset();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        this.replay();
        handler.handle();
        this.verify();
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isSameAs((Object)throwable);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isNull();
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly((Object[])new LuceneWork[]{this.luceneWork1, this.luceneWork2, this.luceneWork3});
    }

    @Test
    public void multipleErrors_works() {
        Capture capture = new Capture();
        this.replay();
        DefaultContextualErrorHandler handler = new DefaultContextualErrorHandler(this.errorHandlerMock);
        this.verify();
        Throwable throwable1 = new Throwable();
        Throwable throwable2 = new Throwable();
        this.reset();
        EasyMock.expect((Object)this.work1.getLuceneWork()).andReturn((Object)this.luceneWork1);
        EasyMock.expect((Object)this.work2.getLuceneWork()).andReturn((Object)this.luceneWork2);
        EasyMock.expect((Object)this.work3.getLuceneWork()).andReturn((Object)this.luceneWork3);
        this.replay();
        handler.markAsFailed(this.work1, throwable1);
        handler.markAsFailed(this.work2, throwable2);
        handler.markAsSkipped(this.work3);
        this.verify();
        this.reset();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        this.replay();
        handler.handle();
        this.verify();
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isSameAs((Object)throwable1);
        Assertions.assertThat((Object[])throwable1.getSuppressed()).containsOnly((Object[])new Throwable[]{throwable2});
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isIn(new Object[]{this.luceneWork1, this.luceneWork2});
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly((Object[])new LuceneWork[]{this.luceneWork1, this.luceneWork2, this.luceneWork3});
    }

    @Test
    public void multipleErrors_workAndNotWork() {
        Capture capture = new Capture();
        this.replay();
        DefaultContextualErrorHandler handler = new DefaultContextualErrorHandler(this.errorHandlerMock);
        this.verify();
        Throwable throwable1 = new Throwable();
        Throwable throwable2 = new Throwable();
        this.reset();
        EasyMock.expect((Object)this.work1.getLuceneWork()).andReturn((Object)this.luceneWork1);
        EasyMock.expect((Object)this.work2.getLuceneWork()).andReturn((Object)this.luceneWork2);
        EasyMock.expect((Object)this.work3.getLuceneWork()).andReturn((Object)this.luceneWork3);
        this.replay();
        handler.markAsFailed(this.work1, throwable1);
        handler.markAsSkipped(this.work2);
        handler.markAsSkipped(this.work3);
        this.verify();
        this.reset();
        this.replay();
        handler.addThrowable(throwable2);
        this.verify();
        this.reset();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        this.replay();
        handler.handle();
        this.verify();
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isSameAs((Object)throwable1);
        Assertions.assertThat((Object[])throwable1.getSuppressed()).containsOnly((Object[])new Throwable[]{throwable2});
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork1);
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly((Object[])new LuceneWork[]{this.luceneWork1, this.luceneWork2, this.luceneWork3});
    }

    private void reset() {
        EasyMock.reset((Object[])this.mocks.toArray());
    }

    private void replay() {
        EasyMock.replay((Object[])this.mocks.toArray());
    }

    private void verify() {
        EasyMock.verify((Object[])this.mocks.toArray());
    }

    private ElasticsearchWork<?> work(int index) {
        ElasticsearchWork mock = (ElasticsearchWork)EasyMock.createMock((String)("work" + index), ElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }

    private LuceneWork luceneWork(int index) {
        LuceneWork mock = (LuceneWork)EasyMock.createMock((String)("luceneWork" + index), LuceneWork.class);
        this.mocks.add(mock);
        return mock;
    }
}

