/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchIndexNullAsTypeCheckingIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void indexNullAs_invalid_boolean() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400027");
        this.thrown.expectMessage("Boolean");
        this.thrown.expectMessage("myField");
        this.init(new Class[]{BooleanFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_date() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400028");
        this.thrown.expectMessage("Date");
        this.thrown.expectMessage("myField");
        this.init(new Class[]{DateFailureTestEntity.class});
    }

    @Indexed
    @Entity
    public static class DateFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="01/01/2013")
        Date myField;
    }

    @Indexed
    @Entity
    public static class BooleanFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="foo")
        boolean myField;
    }
}

