/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchClassBridgeIT
extends SearchTestBase {
    @Rule
    public TestElasticsearchClient elasticsearchClient = new TestElasticsearchClient();

    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 0, 0, 0);
        dob.set(14, 0);
        GolfPlayer hergesheimer = new GolfPlayer.Builder().firstName("Klaus").lastName("Hergesheimer").active(true).dateOfBirth(dob.getTime()).handicap(3.4).driveWidth(285).ranking(311).build();
        s.persist((Object)hergesheimer);
        GolfPlayer kidd = new GolfPlayer.Builder().lastName("Kidd").build();
        s.persist((Object)kidd);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testQueryOnClassBridgeField() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"fullName:\"Klaus Hergesheimer\"");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Class-bridge provided string field")).containsOnly(new Object[]{1L});
        query = ElasticsearchQueries.fromQueryString((String)"age:34");
        result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Class-bridge provided numeric field")).containsOnly(new Object[]{1L});
        tx.commit();
        s.close();
    }

    @Test
    public void testProjectionOfClassBridgeField() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"Hergesheimer");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"fullName", "age"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Object[] projection = (Object[])result.iterator().next();
        ((ObjectAssert)Assertions.assertThat((Object)projection[0]).describedAs("fullName")).isEqualTo((Object)"Klaus Hergesheimer");
        ((IntAssert)Assertions.assertThat((Integer)((Integer)projection[1])).describedAs("age")).isEqualTo(34);
        tx.commit();
        s.close();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2439")
    public void testProjectionOnUnindexedClassBridgeField() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"Hergesheimer");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"fullNameStored"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Object[] projection = (Object[])result.iterator().next();
        ((ObjectAssert)Assertions.assertThat((Object)projection[0]).describedAs("fullNameStored")).isEqualTo((Object)"Klaus Hergesheimer");
        tx.commit();
        s.close();
    }

    @Test
    public void testProjectionOnUnknownBridgeField() throws Exception {
        this.elasticsearchClient.index("golfplayer").mapping(GolfPlayer.class).put("{'properties': {'fieldNotInMapping': {'type':'integer'}}}").index("9999", "{'id':9999,'fieldNotInMapping':42}");
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"fieldNotInMapping:42");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"fieldNotInMapping"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Object[] projection = (Object[])result.iterator().next();
        ((IntAssert)Assertions.assertThat((int)((Number)projection[0]).intValue()).describedAs("fieldNotInMapping")).isEqualTo(42);
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{GolfPlayer.class, GolfCourse.class, Hole.class};
    }
}

