/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2189")
public class ElasticsearchScrollingIT {
    private static final int DEFAULT_MAX_RESULT_WINDOW = 10000;
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{IndexedObject.class});

    @Test
    public void searchBeforeMaxResultWindow() throws Exception {
        this.generateData(0, 10010);
        Query query = this.builder().all().createQuery();
        List results = this.getQuery(query).firstResult(9995).maxResults(5).queryEntityInfos();
        Assert.assertEquals((long)5L, (long)results.size());
        Assert.assertEquals((Object)9995, (Object)((EntityInfo)results.get(0)).getId());
    }

    @Test(expected=SearchException.class)
    public void searchBeyondMaxResultWindow() throws Exception {
        this.generateData(0, 10010);
        Query query = this.builder().all().createQuery();
        this.getQuery(query).firstResult(10001).maxResults(5).queryEntityInfos();
    }

    @Test
    public void scrollBeyondMaxResultWindow() throws Exception {
        this.generateData(0, 10010);
        Query query = this.builder().all().createQuery();
        DocumentExtractor extractor = this.getQuery(query).queryDocumentExtractor();
        for (int i = 0; i < 10010; ++i) {
            EntityInfo info = extractor.extract(i);
            Assert.assertNotNull((Object)info);
            Assert.assertEquals((Object)i, (Object)info.getId());
        }
    }

    @Test
    public void scrollForwardToArbitraryPosition() throws Exception {
        this.generateData(0, 1000);
        Query query = this.builder().all().createQuery();
        DocumentExtractor extractor = this.getQuery(query).queryDocumentExtractor();
        EntityInfo info = extractor.extract(1);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)1, (Object)info.getId());
        info = extractor.extract(500);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)500, (Object)info.getId());
    }

    @Test
    public void scrollBackward() throws Exception {
        this.generateData(0, 1001);
        Query query = this.builder().all().createQuery();
        DocumentExtractor extractor = this.getQuery(query).queryDocumentExtractor();
        EntityInfo info = extractor.extract(1000);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)1000, (Object)info.getId());
        info = extractor.extract(0);
        Assert.assertNotNull((Object)info);
        Assert.assertEquals((Object)0, (Object)info.getId());
    }

    private QueryBuilder builder() {
        return this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(IndexedObject.class).get();
    }

    private HSQuery getQuery(Query luceneQuery) {
        ExtendedSearchIntegrator sf = this.sfHolder.getSearchFactory();
        HSQuery hsQuery = sf.createHSQuery(luceneQuery, new Class[]{IndexedObject.class});
        return hsQuery.projection(new String[]{"id"}).sort(new Sort(new SortField("idSort", SortField.Type.INT)));
    }

    private void generateData(int firstId, int count) throws Exception {
        TransactionContextForTest tc = new TransactionContextForTest();
        for (int id = firstId; id < firstId + count; ++id) {
            Work work = new Work((Object)new IndexedObject(id), (Serializable)Integer.valueOf(id), WorkType.ADD, false);
            this.sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        }
        tc.end();
    }

    @Indexed
    public static class IndexedObject {
        @DocumentId
        @Field(name="idSort")
        @SortableField(forField="idSort")
        private Integer id;

        public IndexedObject(Integer id) {
            this.id = id;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }
    }
}

