/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchIndexNullAsTypeCheckingIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void indexNullAs_invalid_integer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Integer");
        this.init(new Class[]{IntegerFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_long() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Long");
        this.init(new Class[]{LongFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_float() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Float");
        this.init(new Class[]{FloatFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_double() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Double");
        this.init(new Class[]{DoubleFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_boolean() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Boolean");
        this.init(new Class[]{BooleanFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_date() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Date");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{DateFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_calendar() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Calendar");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{CalendarFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_duration() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Long");
        this.init(new Class[]{DurationFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_instant() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Instant");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{InstantFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_localDateTime() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("LocalDateTime");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{LocalDateTimeFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_localDate() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("LocalDate");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{LocalDateFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_localTime() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("LocalTime");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{LocalTimeFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_offsetDateTime() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("OffsetDateTime");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{OffsetDateTimeFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_offsetTime() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("OffsetTime");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{OffsetTimeFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_zonedDateTime() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("ZonedDateTime");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{ZonedDateTimeFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_year() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("Year");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{YearFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_yearMonth() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("YearMonth");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{YearMonthFailureTestEntity.class});
    }

    @Test
    public void indexNullAs_invalid_monthDay() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000325");
        this.thrown.expectMessage("myField");
        this.thrown.expectMessage("MonthDay");
        this.thrown.expectMessage("ISO-8601");
        this.init(new Class[]{MonthDayFailureTestEntity.class});
    }

    @Indexed
    @Entity
    public static class MonthDayFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="12-31")
        MonthDay myField;
    }

    @Indexed
    @Entity
    public static class YearMonthFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="02/2013")
        YearMonth myField;
    }

    @Indexed
    @Entity
    public static class YearFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="2013-02")
        Year myField;
    }

    @Indexed
    @Entity
    public static class ZonedDateTimeFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="2013-02-15T18:25:00+01:00")
        ZonedDateTime myField;
    }

    @Indexed
    @Entity
    public static class OffsetTimeFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="18:25:00[UTC]")
        OffsetTime myField;
    }

    @Indexed
    @Entity
    public static class OffsetDateTimeFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="2013-12-01T18:25:00[UTC]")
        OffsetDateTime myField;
    }

    @Indexed
    @Entity
    public static class LocalTimeFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="18:25:00+01:00")
        LocalTime myField;
    }

    @Indexed
    @Entity
    public static class LocalDateFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="2013-12-01T18:25:00")
        LocalDate myField;
    }

    @Indexed
    @Entity
    public static class LocalDateTimeFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="2013-12-01T18:25:00+01:00")
        LocalDateTime myField;
    }

    @Indexed
    @Entity
    public static class InstantFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="01/01/2013")
        Instant myField;
    }

    @Indexed
    @Entity
    public static class DurationFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="PT13M")
        Duration myField;
    }

    @Indexed
    @Entity
    public static class CalendarFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="01/01/2013")
        Calendar myField;
    }

    @Indexed
    @Entity
    public static class DateFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="01/01/2013")
        Date myField;
    }

    @Indexed
    @Entity
    public static class BooleanFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="foo")
        boolean myField;
    }

    @Indexed
    @Entity
    public static class DoubleFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="foo")
        Double myField;
    }

    @Indexed
    @Entity
    public static class FloatFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="foo")
        Float myField;
    }

    @Indexed
    @Entity
    public static class LongFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="12.1")
        Long myField;
    }

    @Indexed
    @Entity
    public static class IntegerFailureTestEntity {
        @DocumentId
        @Id
        Long id;
        @Field(indexNullAs="12.1")
        Integer myField;
    }
}

