/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.bridge;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.elasticsearch.test.bridge.MapAsInnerObjectFieldBridge;

@Indexed(index="elasticsearchDynamicIndex")
public class ElasticsearchDynamicIndexedValueHolder {
    public static final String INDEX_NAME = "elasticsearchDynamicIndex";
    @DocumentId
    public final String id;
    @Field(norms=Norms.NO, store=Store.YES, analyze=Analyze.YES, name="dynamicField")
    @FieldBridge(impl=MapAsInnerObjectFieldBridge.class, params={@Parameter(name="dynamicMapping", value="true")})
    private Map<String, String> dynamicFields = new HashMap<String, String>();
    @Field(norms=Norms.NO, store=Store.YES, analyze=Analyze.YES, name="strictField")
    @FieldBridge(impl=MapAsInnerObjectFieldBridge.class)
    private Map<String, String> strictFields = new HashMap<String, String>();

    public ElasticsearchDynamicIndexedValueHolder(String id) {
        this.id = id;
    }

    public ElasticsearchDynamicIndexedValueHolder dynamicProperty(String key, String value) {
        this.dynamicFields.put(key, value);
        return this;
    }

    public ElasticsearchDynamicIndexedValueHolder strictProperty(String key, String value) {
        this.strictFields.put(key, value);
        return this;
    }
}

