/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchImplicitProvidedIdIT {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{User.class, UserWithAddress.class}).withIdProvidedImplicit(true);

    @Test
    @TestForIssue(jiraKey="HSEARCH-2431")
    public void testWithProjection() throws Exception {
        ExtendedSearchIntegrator searchIntegrator = this.sfHolder.getSearchFactory();
        User user = new User();
        user.setId(1);
        user.setSurname("Smith");
        this.indexUser(user, (Serializable)((Object)"S:1"), (SearchIntegrator)searchIntegrator);
        QueryBuilder queryBuilder = searchIntegrator.buildQueryBuilder().forEntity(User.class).get();
        Query query = queryBuilder.keyword().onField("surname").matching((Object)"smith").createQuery();
        List entityInfoList = searchIntegrator.createHSQuery(query, new Class[]{User.class}).projection(new String[]{"surname"}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)entityInfoList.size());
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2432")
    public void testWithCustomId() throws Exception {
        ExtendedSearchIntegrator searchIntegrator = this.sfHolder.getSearchFactory();
        User user = new User();
        user.setId(325);
        user.setSurname("Lee");
        String customId = "S:custom_id_325";
        this.indexUser(user, (Serializable)((Object)customId), (SearchIntegrator)searchIntegrator);
        QueryBuilder queryBuilder = searchIntegrator.buildQueryBuilder().forEntity(User.class).get();
        Query query = queryBuilder.keyword().onField("surname").matching((Object)"Lee").createQuery();
        List entityInfoList = searchIntegrator.createHSQuery(query, new Class[]{User.class}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)entityInfoList.size());
        Assert.assertEquals((Object)customId, (Object)((EntityInfo)entityInfoList.iterator().next()).getId());
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2433")
    public void testWithEmbedded() throws Exception {
        ExtendedSearchIntegrator searchIntegrator = this.sfHolder.getSearchFactory();
        UserWithAddress user = new UserWithAddress();
        user.setId(1);
        user.setSurname("Smith");
        Address address = new Address();
        address.setStreet("21st steet");
        address.setNumber(42);
        address.setPostCode("8964");
        user.addAddress(address);
        Work work = new Work((Object)user, (Serializable)((Object)"S:1"), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchIntegrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
        QueryBuilder queryBuilder = searchIntegrator.buildQueryBuilder().forEntity(UserWithAddress.class).get();
        Query query = queryBuilder.keyword().onField("surname").matching((Object)"smith").createQuery();
        List entityInfoList = searchIntegrator.createHSQuery(query, new Class[]{UserWithAddress.class}).projection(new String[]{"surname"}).queryEntityInfos();
        Assert.assertEquals((long)1L, (long)entityInfoList.size());
    }

    private void indexUser(User user, Serializable id, SearchIntegrator searchIntegrator) {
        Work work = new Work((Object)user, id, WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchIntegrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private static class Address {
        @Field(store=Store.YES, analyze=Analyze.NO)
        private String street;
        @Field(store=Store.YES, analyze=Analyze.NO)
        private String postCode;
        @Field(store=Store.YES, analyze=Analyze.NO)
        private int number;

        private Address() {
        }

        public void setStreet(String street) {
            this.street = street;
        }

        public void setPostCode(String postCode) {
            this.postCode = postCode;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    @Indexed
    private static class UserWithAddress {
        @Field(store=Store.YES, analyze=Analyze.NO)
        @SortableField
        private int id;
        @IndexedEmbedded(targetElement=Address.class, indexNullAs="__DEFAULT_NULL_TOKEN__")
        private List<Address> addresses = new ArrayList<Address>();
        @Field(store=Store.YES)
        private String surname;

        private UserWithAddress() {
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }

        public void addAddress(Address address) {
            this.addresses.add(address);
        }
    }

    @Indexed
    private static class User {
        @Field
        private int id;
        @Field(store=Store.YES)
        private String surname;

        private User() {
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setSurname(String surname) {
            this.surname = surname;
        }
    }
}

