/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.bridge;

import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldMetadataCreationContext;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.elasticsearch.bridge.spi.Elasticsearch;
import org.hibernate.search.elasticsearch.cfg.DynamicType;

public class MapAsInnerObjectFieldBridge
implements ParameterizedBridge,
MetadataProvidingFieldBridge {
    public static final String DYNAMIC = "dynamicMapping";
    public DynamicType dynamicType = null;

    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException("This field can only be applied on a Map type field");
        }
        Map userValue = (Map)value;
        for (Map.Entry e : userValue.entrySet()) {
            this.setField(name, String.valueOf(e.getKey()), String.valueOf(e.getValue()), document, luceneOptions);
        }
    }

    private void setField(String fieldPrefix, String key, String value, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addFieldToDocument(fieldPrefix + "." + key, value, document);
    }

    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        FieldMetadataCreationContext field = builder.field(name, FieldType.OBJECT);
        if (this.dynamicType != null) {
            ((Elasticsearch)field.mappedOn(Elasticsearch.class)).dynamic(this.dynamicType);
        }
    }

    public void setParameterValues(Map<String, String> parameters) {
        String dynamicTypeAsString = parameters.get(DYNAMIC);
        if (dynamicTypeAsString != null) {
            this.dynamicType = DynamicType.valueOf((String)dynamicTypeAsString.toUpperCase(Locale.ROOT));
        }
    }
}

