/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch;

import com.google.gson.JsonParser;
import org.hibernate.search.elasticsearch.impl.ElasticsearchJsonQueryDescriptor;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.query.engine.spi.QueryDescriptor;

public class ElasticsearchQueries {
    private static final JsonParser PARSER = new JsonParser();

    private ElasticsearchQueries() {
    }

    public static QueryDescriptor fromJson(String jsonQuery) {
        return new ElasticsearchJsonQueryDescriptor(PARSER.parse(jsonQuery).getAsJsonObject());
    }

    public static QueryDescriptor fromQueryString(String queryStringQuery) {
        JsonBuilder.Object query = JsonBuilder.object().add("query", JsonBuilder.object().add("queryString", JsonBuilder.object().addProperty("query", queryStringQuery)));
        return new ElasticsearchJsonQueryDescriptor(query.build());
    }
}

