/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.logging.impl;

import com.google.gson.JsonElement;
import io.searchbox.client.JestResult;
import java.util.List;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.elasticsearch.client.impl.BackendRequest;
import org.hibernate.search.elasticsearch.client.impl.BulkRequestFailedException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.ClassFormatter;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@MessageLogger(projectCode="HSEARCH")
public interface Log
extends org.hibernate.search.util.logging.impl.Log {
    @Message(id=400001, value="Cannot execute query '%2$s', as targeted entity type '%1$s' is not mapped to an Elasticsearch index")
    public SearchException cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2);

    @Message(id=400002, value="Lucene query '%1$s' cannot be transformed into equivalent Elasticsearch query")
    public SearchException cannotTransformLuceneQueryIntoEsQuery(Query var1);

    @Message(id=400003, value="Lucene filter '%1$s' cannot be transformed into equivalent Elasticsearch query")
    public SearchException cannotTransformLuceneFilterIntoEsQuery(Filter var1);

    @Message(id=400004, value="The sort order RANGE_DEFINITION_ORDER cant not be sent used with Elasticsearch")
    public SearchException cannotSendRangeDefinitionOrderToElasticsearchBackend();

    @Message(id=400005, value="The SortType '%1$s' cannot be used with a null sort field name")
    public SearchException cannotUseThisSortTypeWithNullSortFieldName(SortField.Type var1);

    @Message(id=400006, value="Empty phrase queries are not supported")
    public SearchException cannotQueryOnEmptyPhraseQuery();

    @Message(id=400007, value="Elasticsearch request failed.\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearchRequestFailed(String var1, String var2, @Cause Exception var3);

    @Message(id=400008, value="Elasticsearch request failed.\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public BulkRequestFailedException elasticsearchBulkRequestFailed(String var1, String var2, @Param List<BackendRequest<? extends JestResult>> var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=400009, value="Field '%2$s' in '%1$s' requires a remote analyzer reference (got '%3$s' instead). The analyzer will be ignored.")
    public void analyzerIsNotRemote(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, AnalyzerReference var3);

    @Message(id=400010, value="Elasticsearch connection time-out; check the cluster status, it should be 'green';\n Request:\n========\n%1$sResponse:\n=========\n%2$s")
    public SearchException elasticsearchRequestTimeout(String var1, String var2);

    @Message(id=400011, value="Projection of non-JSON-primitive field values is not supported: '%1$s'")
    public SearchException unsupportedProjectionOfNonJsonPrimitiveFields(JsonElement var1);

    @Message(id=400012, value="Interrupted while waiting for requests to be processed.")
    public SearchException interruptedWhileWaitingForRequestCompletion(@Cause Exception var1);

    @Message(id=400013, value="@Factory method does not return a Filter class or an ElasticsearchFilter class: %1$s.%2$s")
    public SearchException filterFactoryMethodReturnsUnsupportedType(String var1, String var2);

    @Message(id=400014, value="Unable to access @Factory method: %1$s.%2$s")
    public SearchException filterFactoryMethodInaccessible(String var1, String var2, @Cause Exception var3);

    @Message(id=400015, value="Filter implementation does not implement the Filter interface or the ElasticsearchFilter interface: %1$s")
    public SearchException filterHasUnsupportedType(String var1);

    @Message(id=400016, value="TopDocs not available when using Elasticsearch")
    public UnsupportedOperationException documentExtractorTopDocsUnsupported();

    @Message(id=400017, value="Cannot use Lucene query with Elasticsearch")
    public UnsupportedOperationException hsQueryLuceneQueryUnsupported();

    @Message(id=400018, value="Unexpected numeric encoding type for field '%2$s': %1$s")
    public SearchException unexpectedNumericEncodingType(String var1, String var2);

    @Message(id=400019, value="Cannot project field '%2$s' for entity %1$s: unknown field")
    public SearchException unknownFieldForProjection(String var1, String var2);

    @Message(id=400020, value="Could not create mapping for entity type %1$s")
    public SearchException elasticsearchMappingCreationFailed(String var1, @Cause Exception var2);

    @Message(id=400021, value="Unexpected field type for field '%2$s': %1$s")
    public SearchException unexpectedFieldType(String var1, String var2);

    @Message(id=400022, value="Unexpected index status string: '%1$s'. Specify one of 'green', 'yellow' or 'red'.")
    public SearchException unexpectedIndexStatusString(String var1);

    @Message(id=400023, value="Positive timeout value expected, but it was: %1$s")
    public SearchException negativeTimeoutValue(int var1);

    @Message(id=400024, value="Index '%1$s' has status '%3$s', but it is expected to be '%2$s'.")
    public SearchException unexpectedIndexStatus(String var1, String var2, String var3);

    @Message(id=400025, value="With an Elasticsearch backend it is not possible to get a ReaderProvider or an IndexReader")
    public UnsupportedOperationException indexManagerReaderProviderUnsupported();

    @Message(id=400026, value="Faceting request of type %1$s not supported")
    public SearchException facetingRequestHasUnsupportedType(String var1);

    @Message(id=400027, value="The 'indexNullAs' property for field '%2$s' needs to represent a Boolean to match the field type of the index. Please change value from '%1$s' to represent a Boolean.")
    public SearchException nullMarkerNeedsToRepresentABoolean(String var1, String var2);

    @Message(id=400028, value="The 'indexNullAs' property for field '%2$s' needs to represent a Date to match the field type of the index. Please change value from '%1$s' to represent a Date.")
    public SearchException nullMarkerNeedsToRepresentADate(String var1, String var2);

    @Message(id=400029, value="Cannot use an offset ('from', 'firstResult') when scrolling through Elasticsearch results")
    public UnsupportedOperationException unsupportedOffsettedScrolling();

    @Message(id=400030, value="Cannot scroll backward through Elasticsearch results. Previously accessed index was %1$s, requested index is %2$s.")
    public UnsupportedOperationException unsupportedBackwardTraversal(int var1, int var2);

    @Message(id=400031, value="Cannot scroll backward more than %1$s positions through Elasticsearch results. First index still in memory is %2$s, requested index is %3$s.")
    public SearchException backtrackingWindowOverflow(int var1, int var2, int var3);
}

