/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.net.ConnectException;
import java.util.HashMap;
import org.fest.assertions.Assertions;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.test.MasterThesis;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-2274")
public class HostCanBeConfiguredIT
extends SearchInitializationTestBase {
    @Test
    public void shouldApplyConfiguredSingleElasticsearchHost() {
        try {
            this.init("http://localhost:9201");
            Assert.fail((String)"Expecting exception due to unavailable ES host");
        }
        catch (SearchException e) {
            Assertions.assertThat((String)e.getMessage()).startsWith("HSEARCH400007");
            Assertions.assertThat((String)e.getMessage()).contains("Operation: IndicesExist");
            Throwable rootCause = this.getRootCause(e);
            Assertions.assertThat((Throwable)rootCause).isInstanceOf(ConnectException.class);
            Assertions.assertThat((String)rootCause.getMessage()).contains("Connection refused");
        }
    }

    @Test
    public void shouldApplyConfiguredMultipleElasticsearchHosts() {
        try {
            this.init(" http://localhost:9200 http://localhost:9201");
            Assert.fail((String)"Expecting exception due to unavailable ES host");
        }
        catch (SearchException e) {
            Assertions.assertThat((String)e.getMessage()).startsWith("HSEARCH400007");
            Assertions.assertThat((String)e.getMessage()).contains("Operation: CreateIndex");
            Throwable rootCause = this.getRootCause(e);
            Assertions.assertThat((Throwable)rootCause).isInstanceOf(ConnectException.class);
            Assertions.assertThat((String)rootCause.getMessage()).contains("Connection refused");
        }
    }

    private void init(String hosts) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.host", hosts);
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.RECREATE_DELETE.name());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, new Class[]{MasterThesis.class}));
    }

    private Throwable getRootCause(Throwable throwable) {
        Throwable cause;
        while ((cause = throwable.getCause()) != null) {
            throwable = cause;
        }
        return throwable;
    }
}

