/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.deletebyquery;

import java.util.List;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.DeleteByQueryWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.SingularTermDeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.deletebyquery.HockeyPlayer;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DeleteByQueryIT
extends SearchTestBase {
    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        HockeyPlayer hergesheimer = new HockeyPlayer();
        hergesheimer.name = "Hergesheimer";
        hergesheimer.active = true;
        s.persist((Object)hergesheimer);
        HockeyPlayer galore = new HockeyPlayer();
        galore.name = "Galore";
        galore.active = false;
        s.persist((Object)galore);
        HockeyPlayer kidd = new HockeyPlayer();
        kidd.name = "Kidd";
        kidd.active = false;
        s.persist((Object)kidd);
        HockeyPlayer brand = new HockeyPlayer();
        brand.name = "Brand";
        brand.active = true;
        s.persist((Object)brand);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void canDeleteByQuery() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        ExtendedSearchIntegrator integrator = (ExtendedSearchIntegrator)session.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
        DeleteByQueryWork queryWork = new DeleteByQueryWork(HockeyPlayer.class, (DeletionQuery)new SingularTermDeletionQuery("active", "false"));
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork((Work)queryWork, (TransactionContext)tc);
        integrator.getWorker().flushWorks((TransactionContext)tc);
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        Transaction tx = s.beginTransaction();
        List result = session.createFullTextQuery(query, new Class[]{HockeyPlayer.class}).list();
        Assertions.assertThat((List)result).onProperty("name").containsOnly(new Object[]{"Hergesheimer", "Brand"});
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{HockeyPlayer.class};
    }
}

