/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.fest.assertions.Assertions;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ToElasticsearchDSLIT
extends SearchTestBase {
    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Letter letter = new Letter("Important letter", "Gunnar Morling");
        s.persist((Object)letter);
        letter = new Letter("Dear Sanne...", "Gunnar Morling");
        s.persist((Object)letter);
        tx.commit();
        s.close();
    }

    @Test
    public void testDSLPhraseQueryWithoutAnalyzer() {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)new PrefixQuery(new Term("message", "import")), new Class[]{Letter.class});
            String queryString = fullTextQuery.getQueryString();
            JsonHelper.assertJsonEquals("{'query':{'prefix':{'message':{'value':'import'}}}}", queryString);
            List letters = fullTextQuery.list();
            Assertions.assertThat((List)letters).hasSize(1);
            Assertions.assertThat((List)letters).onProperty("message").containsExactly(new Object[]{"Important letter"});
        }
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[]{Letter.class}).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Letter.class};
    }

    @Entity
    @Indexed
    public static class Letter {
        @Id
        @GeneratedValue
        private Integer id;
        @Field
        @Analyzer(definition="english")
        private String message;
        @Field
        private String signature;
        @Field
        @DateBridge(resolution=Resolution.DAY)
        private Date dateWritten;
        @Field
        @CalendarBridge(resolution=Resolution.DAY)
        private Calendar dateSent;
        @Field
        private boolean personal;
        @Field
        private float shippingCost;

        public Letter() {
        }

        public Letter(String message, String signature) {
            this.message = message;
            this.signature = signature;
        }

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public Date getDateWritten() {
            return this.dateWritten;
        }

        public void setDateWritten(Date dateWritten) {
            this.dateWritten = dateWritten;
        }

        public Calendar getDateSent() {
            return this.dateSent;
        }

        public void setDateSent(Calendar dateSent) {
            this.dateSent = dateSent;
        }
    }
}

