/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.processor.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import org.easymock.EasyMock;
import org.hibernate.search.elasticsearch.processor.impl.ContextualErrorHandler;
import org.hibernate.search.elasticsearch.processor.impl.DefaultElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkExecutor;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkSequenceBuilder;
import org.hibernate.search.elasticsearch.processor.impl.FlushableElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.BulkResult;
import org.hibernate.search.elasticsearch.work.impl.BulkResultItemExtractor;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.test.util.FutureAssert;
import org.junit.Before;
import org.junit.Test;

public class DefaultElasticsearchWorkSequenceBuilderTest {
    private final List<Object> mocks = new ArrayList<Object>();
    private ElasticsearchWorkExecutor executorMock;
    private FlushableElasticsearchWorkExecutionContext contextMock;
    private Supplier<FlushableElasticsearchWorkExecutionContext> contextSupplierMock;
    private ContextualErrorHandler errorHandlerMock;
    private Supplier<ContextualErrorHandler> errorHandlerSupplierMock;

    @Before
    public void initMocks() {
        this.executorMock = (ElasticsearchWorkExecutor)EasyMock.createStrictMock(ElasticsearchWorkExecutor.class);
        this.contextMock = (FlushableElasticsearchWorkExecutionContext)EasyMock.createStrictMock(FlushableElasticsearchWorkExecutionContext.class);
        this.contextSupplierMock = (Supplier)EasyMock.createStrictMock(Supplier.class);
        this.errorHandlerMock = (ContextualErrorHandler)EasyMock.createStrictMock(ContextualErrorHandler.class);
        this.errorHandlerSupplierMock = (Supplier)EasyMock.createStrictMock(Supplier.class);
        this.mocks.addAll(Arrays.asList(this.executorMock, this.contextMock, this.contextSupplierMock, this.errorHandlerMock, this.errorHandlerSupplierMock));
    }

    @Test
    public void simple() {
        ElasticsearchWork work1 = this.work(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture<Object> work1Future = new CompletableFuture<Object>();
        CompletableFuture<Object> work2Future = new CompletableFuture<Object>();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        builder.addNonBulkExecution(work1);
        this.verify();
        this.reset();
        this.replay();
        builder.addNonBulkExecution(work2);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture futureSequence = builder.build();
        this.verify();
        FutureAssert.assertThat((Future)futureSequence).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(work1, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work1Future);
        this.replay();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureSequence).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(work2, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work2Future);
        this.replay();
        work1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureSequence).isPending();
        this.reset();
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work2Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureSequence).isPending();
        this.reset();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)futureSequence).isSuccessful((Object)null);
    }

    @Test
    public void bulk() {
        ElasticsearchWork work1 = this.work(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        ElasticsearchWork work4 = this.work(4);
        ElasticsearchWork bulkWork = this.work(5);
        BulkResult bulkResultMock = (BulkResult)EasyMock.createStrictMock(BulkResult.class);
        this.mocks.add(bulkResultMock);
        BulkResultItemExtractor bulkItemResultExtractorMock = (BulkResultItemExtractor)EasyMock.createStrictMock(BulkResultItemExtractor.class);
        this.mocks.add(bulkItemResultExtractorMock);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture<BulkResult> bulkResultFuture = new CompletableFuture<BulkResult>();
        CompletableFuture<Object> work1Future = new CompletableFuture<Object>();
        CompletableFuture<Object> work2Future = new CompletableFuture<Object>();
        CompletableFuture<Object> work3Future = new CompletableFuture<Object>();
        CompletableFuture<Object> work4Future = new CompletableFuture<Object>();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        builder.addNonBulkExecution(work1);
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work2, 0);
        extractionStep.add(work3, 1);
        builder.addNonBulkExecution(work4);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        this.reset();
        this.replay();
        CompletableFuture sequenceFuture = builder.build();
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(work1, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work1Future);
        this.replay();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.replay();
        work1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(bulkWork, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(bulkResultFuture);
        this.replay();
        bulkWorkFuture.complete(bulkWork);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)bulkResultMock.withContext((ElasticsearchWorkExecutionContext)this.contextMock)).andReturn((Object)bulkItemResultExtractorMock);
        EasyMock.expect((Object)bulkItemResultExtractorMock.extract(work2, 0)).andReturn(work2Future);
        EasyMock.expect((Object)bulkItemResultExtractorMock.extract(work3, 1)).andReturn(work3Future);
        this.replay();
        bulkResultFuture.complete(bulkResultMock);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isSuccessful((Object)bulkResultMock);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.replay();
        work3Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(work4, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work4Future);
        this.replay();
        work2Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work4Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful((Object)null);
    }

    @Test
    public void newSequenceOnReset() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        CompletableFuture<Object> previousFuture1 = new CompletableFuture<Object>();
        CompletableFuture<Object> previousFuture2 = new CompletableFuture<Object>();
        CompletableFuture work1Future = new CompletableFuture();
        CompletableFuture<Object> work2Future = new CompletableFuture<Object>();
        CompletableFuture<Object> sequence2FlushFuture = new CompletableFuture<Object>();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture1);
        this.verify();
        this.reset();
        this.replay();
        builder.addNonBulkExecution(work1);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequence1Future = builder.build();
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(work1, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work1Future);
        this.replay();
        previousFuture1.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture2);
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        this.reset();
        this.replay();
        builder.addNonBulkExecution(work2);
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        this.reset();
        this.replay();
        CompletableFuture sequence2Future = builder.build();
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        FutureAssert.assertThat((Future)sequence2Future).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(work2, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work2Future);
        this.replay();
        previousFuture2.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        FutureAssert.assertThat((Future)sequence2Future).isPending();
        this.reset();
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(sequence2FlushFuture);
        this.replay();
        work2Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        FutureAssert.assertThat((Future)sequence2Future).isPending();
        this.reset();
        this.replay();
        sequence2FlushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequence1Future).isPending();
        FutureAssert.assertThat((Future)sequence2Future).isSuccessful((Object)null);
    }

    @Test
    public void error_work() {
        ElasticsearchWork work1 = this.work(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture work1Future = new CompletableFuture();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyException exception = new MyException();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        EasyMock.expect((Object)this.executorMock.submit(work1, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work1Future);
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        builder.init(previousFuture);
        builder.addNonBulkExecution(work1);
        builder.addNonBulkExecution(work2);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsFailed(work1, (Throwable)exception);
        this.errorHandlerMock.markAsSkipped(work2);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work1Future.completeExceptionally(exception);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_bulk_work() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyException exception = new MyException();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work1, 0);
        extractionStep.add(work2, 1);
        extractionStep.add(work3, 2);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsSkipped(work1);
        this.errorHandlerMock.markAsSkipped(work2);
        this.errorHandlerMock.markAsSkipped(work3);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        bulkWorkFuture.completeExceptionally(exception);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isFailed((Throwable)exception);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.addThrowable((Throwable)exception);
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_bulk_result() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        ElasticsearchWork bulkWork = this.work(4);
        BulkResult bulkWorkResultMock = (BulkResult)EasyMock.createStrictMock(BulkResult.class);
        this.mocks.add(bulkWorkResultMock);
        BulkResultItemExtractor bulkResultItemExtractorMock = (BulkResultItemExtractor)EasyMock.createStrictMock(BulkResultItemExtractor.class);
        this.mocks.add(bulkResultItemExtractorMock);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture bulkResultFuture = new CompletableFuture();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyException exception = new MyException();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work1, 0);
        extractionStep.add(work2, 1);
        extractionStep.add(work3, 2);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(bulkWork, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(bulkResultFuture);
        this.replay();
        bulkWorkFuture.complete(bulkWork);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsSkipped(work1);
        this.errorHandlerMock.markAsSkipped(work2);
        this.errorHandlerMock.markAsSkipped(work3);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        bulkResultFuture.completeExceptionally(exception);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isFailed((Throwable)exception);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.addThrowable((Throwable)exception);
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_bulk_resultExtraction_singleFailure() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        BulkableElasticsearchWork<Void> work4 = this.bulkableWork(4);
        ElasticsearchWork bulkWork = this.work(5);
        BulkResult bulkResultMock = (BulkResult)EasyMock.createStrictMock(BulkResult.class);
        this.mocks.add(bulkResultMock);
        BulkResultItemExtractor bulkResultItemExtractorMock = (BulkResultItemExtractor)EasyMock.createStrictMock(BulkResultItemExtractor.class);
        this.mocks.add(bulkResultItemExtractorMock);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture<BulkResult> bulkResultFuture = new CompletableFuture<BulkResult>();
        CompletableFuture<Object> work1Future = new CompletableFuture<Object>();
        CompletableFuture<Object> work3Future = new CompletableFuture<Object>();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyRuntimeException exception = new MyRuntimeException();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work1, 0);
        extractionStep.add(work2, 1);
        extractionStep.add(work3, 2);
        builder.addNonBulkExecution(work4);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(bulkWork, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(bulkResultFuture);
        this.replay();
        bulkWorkFuture.complete(bulkWork);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)bulkResultMock.withContext((ElasticsearchWorkExecutionContext)this.contextMock)).andReturn((Object)bulkResultItemExtractorMock);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work1, 0)).andReturn(work1Future);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work2, 1)).andThrow((Throwable)exception);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work3, 2)).andReturn(work3Future);
        this.errorHandlerMock.markAsFailed(work2, (Throwable)exception);
        this.replay();
        bulkResultFuture.complete(bulkResultMock);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isSuccessful((Object)bulkResultMock);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.replay();
        work1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsSkipped(work4);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work3Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_bulk_resultExtraction_multipleFailures() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        ElasticsearchWork bulkWork = this.work(4);
        BulkResult bulkResultMock = (BulkResult)EasyMock.createStrictMock(BulkResult.class);
        this.mocks.add(bulkResultMock);
        BulkResultItemExtractor bulkItemResultExtractorMock = (BulkResultItemExtractor)EasyMock.createStrictMock(BulkResultItemExtractor.class);
        this.mocks.add(bulkItemResultExtractorMock);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture<BulkResult> bulkResultFuture = new CompletableFuture<BulkResult>();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyRuntimeException exception1 = new MyRuntimeException();
        MyRuntimeException exception2 = new MyRuntimeException();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work1, 0);
        extractionStep.add(work2, 1);
        builder.addNonBulkExecution(work3);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(bulkWork, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(bulkResultFuture);
        this.replay();
        bulkWorkFuture.complete(bulkWork);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)bulkResultMock.withContext((ElasticsearchWorkExecutionContext)this.contextMock)).andReturn((Object)bulkItemResultExtractorMock);
        EasyMock.expect((Object)bulkItemResultExtractorMock.extract(work1, 0)).andThrow((Throwable)exception1);
        EasyMock.expect((Object)bulkItemResultExtractorMock.extract(work2, 1)).andThrow((Throwable)exception2);
        this.errorHandlerMock.markAsFailed(work1, (Throwable)exception1);
        this.errorHandlerMock.markAsFailed(work2, (Throwable)exception2);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        bulkResultFuture.complete(bulkResultMock);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isSuccessful((Object)bulkResultMock);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_bulk_resultExtraction_future_singleFailure() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        BulkableElasticsearchWork<Void> work4 = this.bulkableWork(4);
        ElasticsearchWork bulkWork = this.work(5);
        BulkResult bulkResultMock = (BulkResult)EasyMock.createStrictMock(BulkResult.class);
        this.mocks.add(bulkResultMock);
        BulkResultItemExtractor bulkResultItemExtractorMock = (BulkResultItemExtractor)EasyMock.createStrictMock(BulkResultItemExtractor.class);
        this.mocks.add(bulkResultItemExtractorMock);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture<BulkResult> bulkResultFuture = new CompletableFuture<BulkResult>();
        CompletableFuture<Object> work1Future = new CompletableFuture<Object>();
        CompletableFuture work2Future = new CompletableFuture();
        CompletableFuture<Object> work3Future = new CompletableFuture<Object>();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyException exception = new MyException();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work1, 0);
        extractionStep.add(work2, 1);
        extractionStep.add(work3, 2);
        builder.addNonBulkExecution(work4);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(bulkWork, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(bulkResultFuture);
        this.replay();
        bulkWorkFuture.complete(bulkWork);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)bulkResultMock.withContext((ElasticsearchWorkExecutionContext)this.contextMock)).andReturn((Object)bulkResultItemExtractorMock);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work1, 0)).andReturn(work1Future);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work2, 1)).andReturn(work2Future);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work3, 2)).andReturn(work3Future);
        this.replay();
        bulkResultFuture.complete(bulkResultMock);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isSuccessful((Object)bulkResultMock);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.replay();
        work1Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsFailed(work2, (Throwable)exception);
        this.replay();
        work2Future.completeExceptionally(exception);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsSkipped(work4);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work3Future.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_bulk_resultExtraction_future_multipleFailures() {
        BulkableElasticsearchWork<Void> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<Void> work3 = this.bulkableWork(3);
        ElasticsearchWork bulkWork = this.work(4);
        BulkResult bulkResultMock = (BulkResult)EasyMock.createStrictMock(BulkResult.class);
        this.mocks.add(bulkResultMock);
        BulkResultItemExtractor bulkResultItemExtractorMock = (BulkResultItemExtractor)EasyMock.createStrictMock(BulkResultItemExtractor.class);
        this.mocks.add(bulkResultItemExtractorMock);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture bulkWorkFuture = new CompletableFuture();
        CompletableFuture<BulkResult> bulkResultFuture = new CompletableFuture<BulkResult>();
        CompletableFuture work1Future = new CompletableFuture();
        CompletableFuture work2Future = new CompletableFuture();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyException exception1 = new MyException();
        MyException exception2 = new MyException();
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        this.verify();
        this.reset();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        this.replay();
        builder.init(previousFuture);
        this.verify();
        this.reset();
        this.replay();
        CompletableFuture sequenceBuilderBulkResultFuture = builder.addBulkExecution(bulkWorkFuture);
        ElasticsearchWorkSequenceBuilder.BulkResultExtractionStep extractionStep = builder.startBulkResultExtraction(sequenceBuilderBulkResultFuture);
        extractionStep.add(work1, 0);
        extractionStep.add(work2, 1);
        builder.addNonBulkExecution(work3);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)this.executorMock.submit(bulkWork, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(bulkResultFuture);
        this.replay();
        bulkWorkFuture.complete(bulkWork);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isPending();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        EasyMock.expect((Object)bulkResultMock.withContext((ElasticsearchWorkExecutionContext)this.contextMock)).andReturn((Object)bulkResultItemExtractorMock);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work1, 0)).andReturn(work1Future);
        EasyMock.expect((Object)bulkResultItemExtractorMock.extract(work2, 1)).andReturn(work2Future);
        this.replay();
        bulkResultFuture.complete(bulkResultMock);
        this.verify();
        FutureAssert.assertThat((Future)sequenceBuilderBulkResultFuture).isSuccessful((Object)bulkResultMock);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsFailed(work2, (Throwable)exception2);
        this.replay();
        work2Future.completeExceptionally(exception2);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsFailed(work1, (Throwable)exception1);
        this.errorHandlerMock.markAsSkipped(work3);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work1Future.completeExceptionally(exception1);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.handle();
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isSuccessful();
    }

    @Test
    public void error_handler() {
        ElasticsearchWork work1 = this.work(1);
        BulkableElasticsearchWork<Void> work2 = this.bulkableWork(2);
        CompletableFuture<Object> previousFuture = new CompletableFuture<Object>();
        CompletableFuture work1Future = new CompletableFuture();
        CompletableFuture<Object> flushFuture = new CompletableFuture<Object>();
        MyException exception = new MyException();
        IllegalStateException handlerException = new IllegalStateException();
        EasyMock.expect((Object)this.contextSupplierMock.get()).andReturn((Object)this.contextMock);
        EasyMock.expect((Object)this.errorHandlerSupplierMock.get()).andReturn((Object)this.errorHandlerMock);
        EasyMock.expect((Object)this.executorMock.submit(work1, (ElasticsearchWorkExecutionContext)this.contextMock)).andReturn(work1Future);
        this.replay();
        DefaultElasticsearchWorkSequenceBuilder builder = new DefaultElasticsearchWorkSequenceBuilder(this.executorMock, this.contextSupplierMock, this.errorHandlerSupplierMock);
        builder.init(previousFuture);
        builder.addNonBulkExecution(work1);
        builder.addNonBulkExecution(work2);
        CompletableFuture sequenceFuture = builder.build();
        previousFuture.complete(null);
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.markAsFailed(work1, (Throwable)exception);
        this.errorHandlerMock.markAsSkipped(work2);
        EasyMock.expect((Object)this.contextMock.flush()).andReturn(flushFuture);
        this.replay();
        work1Future.completeExceptionally(exception);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isPending();
        this.reset();
        this.errorHandlerMock.handle();
        EasyMock.expectLastCall().andThrow((Throwable)handlerException);
        this.replay();
        flushFuture.complete(null);
        this.verify();
        FutureAssert.assertThat((Future)sequenceFuture).isFailed((Throwable)handlerException);
    }

    private void reset() {
        EasyMock.reset((Object[])this.mocks.toArray());
    }

    private void replay() {
        EasyMock.replay((Object[])this.mocks.toArray());
    }

    private void verify() {
        EasyMock.verify((Object[])this.mocks.toArray());
    }

    private <T> ElasticsearchWork<T> work(int index) {
        ElasticsearchWork mock = (ElasticsearchWork)EasyMock.createStrictMock((String)("work" + index), ElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }

    private BulkableElasticsearchWork<Void> bulkableWork(int index) {
        BulkableElasticsearchWork mock = (BulkableElasticsearchWork)EasyMock.createStrictMock((String)("bulkableWork" + index), BulkableElasticsearchWork.class);
        this.mocks.add(mock);
        return mock;
    }

    private static class MyRuntimeException
    extends RuntimeException {
        private MyRuntimeException() {
        }
    }

    private static class MyException
    extends Exception {
        private MyException() {
        }
    }
}

