/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import junit.framework.Assert;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.Test;

public class TransactionsExpectedTest {
    @Test
    public void testDefaultImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        this.verifyTransactionsExpectedOption(true, cfg);
    }

    @Test
    public void testTransactionsNotExpected() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setTransactionsExpected(false);
        this.verifyTransactionsExpectedOption(false, cfg);
    }

    @Test
    public void testTransactionsExpected() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setTransactionsExpected(true);
        this.verifyTransactionsExpectedOption(true, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyTransactionsExpectedOption(boolean expectation, ManualConfiguration cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        cfg.addClass(Document.class);
        MutableSearchFactory sf = (MutableSearchFactory)new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        try {
            Assert.assertEquals((boolean)expectation, (boolean)sf.isTransactionManagerExpected());
            sf.addClasses(new Class[]{Dvd.class});
            Assert.assertEquals((boolean)expectation, (boolean)sf.isTransactionManagerExpected());
        }
        finally {
            sf.close();
        }
    }

    @Indexed
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }

    public static final class Document {
        long id;
        String title;
    }
}

