/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionHelperTest {
    @Test
    public void testIsSearchAnnotation() throws Exception {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(IndexedEmbedded.class);
        Annotation annotation = AnnotationFactory.create((AnnotationDescriptor)descriptor);
        Assert.assertTrue((boolean)ReflectionHelper.isSearchAnnotation((Annotation)annotation));
        descriptor = new AnnotationDescriptor(Override.class);
        annotation = AnnotationFactory.create((AnnotationDescriptor)descriptor);
        Assert.assertFalse((boolean)ReflectionHelper.isSearchAnnotation((Annotation)annotation));
    }

    @Test
    public void testIsSearchEnabled() throws Exception {
        JavaReflectionManager reflectionManager = new JavaReflectionManager();
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations((XClass)reflectionManager.toXClass(A.class)));
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations((XClass)reflectionManager.toXClass(B.class)));
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations((XClass)reflectionManager.toXClass(C.class)));
        Assert.assertTrue((String)"Should be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations((XClass)reflectionManager.toXClass(D.class)));
        Assert.assertFalse((String)"Should not be a search enabled class", (boolean)ReflectionHelper.containsSearchAnnotations((XClass)reflectionManager.toXClass(E.class)));
    }

    public class E {
    }

    @Analyzer
    public class D {
    }

    public class C {
        @FieldBridge
        public String getFoo() {
            return null;
        }
    }

    public class B {
        @IndexedEmbedded
        private List<A> aList;
    }

    public class A {
        @Field
        private String name;
    }
}

