/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.DynamicShardingEntityIndexBinding;
import org.hibernate.search.engine.impl.EntityIndexBindingFactory;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.indexes.interceptor.DefaultEntityInterceptor;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.internals.SearchFactoryImplementorWithShareableState;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.store.impl.DirectoryProviderFactory;
import org.hibernate.search.store.impl.IdHashShardingStrategy;
import org.hibernate.search.store.impl.NotShardedStrategy;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class IndexManagerHolder {
    private static final Log log = LoggerFactory.make();
    private static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final String NBR_OF_SHARDS = "sharding_strategy.nbr_of_shards";
    private static final String INDEX_SHARD_ID_SEPARATOR = ".";
    private final Map<String, IndexManager> indexManagersRegistry = new ConcurrentHashMap<String, IndexManager>();

    public synchronized MutableEntityIndexBinding buildEntityIndexBinding(XClass entity, Class mappedClass, SearchConfiguration cfg, WorkerBuildContext context) {
        String indexName = IndexManagerHolder.getIndexName(entity, cfg);
        Properties[] indexProperties = IndexManagerHolder.getIndexProperties(cfg, indexName);
        Similarity similarity = this.createSimilarity(indexName, cfg, indexProperties[0], entity);
        boolean isDynamicSharding = this.isShardingDynamic(indexProperties[0]);
        IndexManager[] indexManagers = new IndexManager[]{};
        if (!isDynamicSharding) {
            indexManagers = this.createIndexManagers(indexName, indexProperties, similarity, mappedClass, cfg, context);
        }
        IndexShardingStrategy shardingStrategy = null;
        if (!isDynamicSharding) {
            shardingStrategy = this.createIndexShardingStrategy(indexProperties, indexManagers);
        }
        ShardIdentifierProvider shardIdentifierProvider = null;
        if (isDynamicSharding) {
            shardIdentifierProvider = this.createShardIdentifierProvider(context, indexProperties[0]);
        }
        EntityIndexingInterceptor<?> interceptor = this.createEntityIndexingInterceptor(entity);
        return EntityIndexBindingFactory.buildEntityIndexBinder(entity.getClass(), indexManagers, shardingStrategy, shardIdentifierProvider, similarity, interceptor, isDynamicSharding, indexProperties[0], indexName, context, this, cfg.getIndexManagerFactory());
    }

    public IndexManager getOrCreateIndexManager(String indexBaseName, DynamicShardingEntityIndexBinding entityIndexBinding) {
        return this.getOrCreateIndexManager(indexBaseName, null, entityIndexBinding);
    }

    public IndexManager getOrCreateIndexManager(String indexBaseName, String shardName, DynamicShardingEntityIndexBinding entityIndexBinding) {
        IndexManager indexManager;
        String indexName = indexBaseName;
        if (shardName != null) {
            indexName = indexName + INDEX_SHARD_ID_SEPARATOR + shardName;
        }
        if ((indexManager = this.indexManagersRegistry.get(indexName)) != null) {
            indexManager.addContainedEntity(entityIndexBinding.getDocumentBuilder().getBeanClass());
            return indexManager;
        }
        SearchFactoryImplementor searchFactory = entityIndexBinding.getSearchFactory();
        if (!WorkerBuildContext.class.isAssignableFrom(searchFactory.getClass())) {
            throw log.assertionFailureCannotCastToWorkerBuilderContext(searchFactory.getClass());
        }
        WorkerBuildContext context = (WorkerBuildContext)((Object)searchFactory);
        Properties properties = entityIndexBinding.getProperties();
        if (shardName != null) {
            properties = new MaskedProperty(properties, shardName, properties);
        }
        indexManager = this.createIndexManager(indexName, entityIndexBinding.getDocumentBuilder().getBeanClass(), entityIndexBinding.getSimilarity(), properties, entityIndexBinding.getIndexManagerFactory(), context);
        indexManager.setSearchFactory(searchFactory);
        return indexManager;
    }

    public Collection<IndexManager> getIndexManagers() {
        return this.indexManagersRegistry.values();
    }

    public void setActiveSearchFactory(SearchFactoryImplementorWithShareableState factory) {
        for (IndexManager indexManager : this.getIndexManagers()) {
            indexManager.setSearchFactory(factory);
        }
    }

    public synchronized void stop() {
        for (IndexManager indexManager : this.getIndexManagers()) {
            indexManager.destroy();
        }
        this.indexManagersRegistry.clear();
    }

    public IndexManager getIndexManager(String targetIndexName) {
        if (targetIndexName == null) {
            throw log.nullIsInvalidIndexName();
        }
        return this.indexManagersRegistry.get(targetIndexName);
    }

    private Class<? extends EntityIndexingInterceptor> getInterceptorClassFromHierarchy(XClass entity, Indexed indexedAnnotation) {
        Class<? extends EntityIndexingInterceptor> result = indexedAnnotation.interceptor();
        XClass superEntity = entity;
        while (result == DefaultEntityInterceptor.class) {
            if ((superEntity = superEntity.getSuperclass()) == null) {
                return result;
            }
            Indexed indexAnnForSuperclass = (Indexed)superEntity.getAnnotation(Indexed.class);
            result = indexAnnForSuperclass != null ? indexAnnForSuperclass.interceptor() : result;
        }
        return result;
    }

    private IndexManager createIndexManager(String indexName, Similarity indexSimilarity, IndexManagerFactory indexManagerFactory, Properties properties, WorkerBuildContext context) {
        String indexManagerImplementationName = properties.getProperty("indexmanager");
        IndexManager manager = StringHelper.isEmpty(indexManagerImplementationName) ? indexManagerFactory.createDefaultIndexManager() : indexManagerFactory.createIndexManagerByName(indexManagerImplementationName);
        try {
            manager.initialize(indexName, properties, indexSimilarity, context);
            return manager;
        }
        catch (Exception e) {
            throw log.unableToInitializeIndexManager(indexName, e);
        }
    }

    private static String getIndexName(XClass clazz, SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        Class<?> aClass = cfg.getClassMapping(clazz.getName());
        XClass rootIndex = null;
        do {
            XClass currentClazz;
            Indexed indexAnn;
            if ((indexAnn = (Indexed)(currentClazz = reflectionManager.toXClass(aClass)).getAnnotation(Indexed.class)) == null) continue;
            if (indexAnn.index().length() != 0) {
                return indexAnn.index();
            }
            rootIndex = currentClazz;
        } while ((aClass = aClass.getSuperclass()) != null);
        if (rootIndex != null) {
            return rootIndex.getName();
        }
        throw new SearchException("Trying to extract the index name from a non @Indexed class: " + clazz.getName());
    }

    private static Properties[] getIndexProperties(SearchConfiguration cfg, String indexName) {
        MaskedProperty globalProperties;
        MaskedProperty rootCfg = new MaskedProperty(cfg.getProperties(), "hibernate.search");
        MaskedProperty directoryLocalProperties = new MaskedProperty(rootCfg, indexName, globalProperties = new MaskedProperty(rootCfg, "default"));
        String shardsCountValue = ((Properties)directoryLocalProperties).getProperty(NBR_OF_SHARDS);
        if (shardsCountValue == null) {
            return new Properties[]{directoryLocalProperties};
        }
        int shardsCount = ConfigurationParseHelper.parseInt(shardsCountValue, "'" + shardsCountValue + "' is not a valid value for " + NBR_OF_SHARDS);
        if (shardsCount <= 0) {
            throw log.getInvalidShardCountException(shardsCount);
        }
        Properties[] shardLocalProperties = new Properties[shardsCount];
        for (int i = 0; i < shardsCount; ++i) {
            shardLocalProperties[i] = new MaskedProperty(directoryLocalProperties, Integer.toString(i), directoryLocalProperties);
        }
        return shardLocalProperties;
    }

    private ShardIdentifierProvider createShardIdentifierProvider(WorkerBuildContext context, Properties indexProperty) {
        String shardIdentityProviderName = indexProperty.getProperty(SHARDING_STRATEGY);
        ShardIdentifierProvider shardIdentifierProvider = ClassLoaderHelper.instanceFromName(ShardIdentifierProvider.class, shardIdentityProviderName, DirectoryProviderFactory.class.getClassLoader(), "ShardIdentifierProvider");
        shardIdentifierProvider.initialize(new MaskedProperty(indexProperty, SHARDING_STRATEGY), context);
        return shardIdentifierProvider;
    }

    private EntityIndexingInterceptor<?> createEntityIndexingInterceptor(XClass entity) {
        Indexed indexedAnnotation = (Indexed)entity.getAnnotation(Indexed.class);
        EntityIndexingInterceptor interceptor = null;
        if (indexedAnnotation != null) {
            Class<? extends EntityIndexingInterceptor> interceptorClass = this.getInterceptorClassFromHierarchy(entity, indexedAnnotation);
            interceptor = interceptorClass == DefaultEntityInterceptor.class ? null : ClassLoaderHelper.instanceFromClass(EntityIndexingInterceptor.class, interceptorClass, "IndexingActionInterceptor for " + entity.getName());
        }
        return interceptor;
    }

    private Similarity createSimilarity(String directoryProviderName, SearchConfiguration cfg, Properties indexProperties, XClass clazz) {
        Object classLevelSimilarity = null;
        List<XClass> hierarchyClasses = ReflectionHelper.createXClassHierarchy(clazz);
        Class<?> similarityClass = null;
        for (XClass hierarchyClass : hierarchyClasses) {
            org.hibernate.search.annotations.Similarity similarityAnnotation = (org.hibernate.search.annotations.Similarity)hierarchyClass.getAnnotation(org.hibernate.search.annotations.Similarity.class);
            if (similarityAnnotation == null) continue;
            Class<?> tmpSimilarityClass = similarityAnnotation.impl();
            if (similarityClass != null && !similarityClass.equals(tmpSimilarityClass)) {
                throw log.getMultipleInconsistentSimilaritiesInClassHierarchyException(clazz.getName());
            }
            similarityClass = tmpSimilarityClass;
            classLevelSimilarity = ClassLoaderHelper.instanceFromClass(Similarity.class, similarityClass, "Similarity class for index " + directoryProviderName);
        }
        Object configLevelSimilarity = null;
        String similarityClassName = indexProperties.getProperty("similarity");
        if (similarityClassName != null) {
            configLevelSimilarity = ClassLoaderHelper.instanceFromName(Similarity.class, similarityClassName, DirectoryProviderFactory.class.getClassLoader(), "Similarity class for index " + directoryProviderName);
        }
        if (classLevelSimilarity != null && configLevelSimilarity != null) {
            throw log.getInconsistentSimilaritySettingBetweenAnnotationsAndConfigPropertiesException(classLevelSimilarity.getClass().getName(), configLevelSimilarity.getClass().getCanonicalName());
        }
        if (classLevelSimilarity != null) {
            return classLevelSimilarity;
        }
        if (configLevelSimilarity != null) {
            return configLevelSimilarity;
        }
        String defaultSimilarityClassName = cfg.getProperty("hibernate.search.similarity");
        if (StringHelper.isEmpty(defaultSimilarityClassName)) {
            return Similarity.getDefault();
        }
        return ClassLoaderHelper.instanceFromName(Similarity.class, defaultSimilarityClassName, ConfigContext.class.getClassLoader(), "default similarity");
    }

    private IndexShardingStrategy createIndexShardingStrategy(Properties[] indexProps, IndexManager[] indexManagers) {
        String shardingStrategyName = indexProps[0].getProperty(SHARDING_STRATEGY);
        IndexShardingStrategy shardingStrategy = shardingStrategyName == null ? (indexProps.length == 1 ? new NotShardedStrategy() : new IdHashShardingStrategy()) : ClassLoaderHelper.instanceFromName(IndexShardingStrategy.class, shardingStrategyName, DirectoryProviderFactory.class.getClassLoader(), "IndexShardingStrategy");
        shardingStrategy.initialize(new MaskedProperty(indexProps[0], SHARDING_STRATEGY), indexManagers);
        return shardingStrategy;
    }

    private IndexManager[] createIndexManagers(String indexBaseName, Properties[] indexProperties, Similarity similarity, Class<?> mappedClass, SearchConfiguration configuration, WorkerBuildContext context) {
        int nbrOfIndexManagers = indexProperties.length;
        IndexManager[] indexManagers = new IndexManager[nbrOfIndexManagers];
        for (int index = 0; index < nbrOfIndexManagers; ++index) {
            String indexManagerName = nbrOfIndexManagers > 1 ? indexBaseName + INDEX_SHARD_ID_SEPARATOR + index : indexBaseName;
            Properties indexProp = indexProperties[index];
            IndexManager indexManager = this.indexManagersRegistry.get(indexManagerName);
            if (indexManager == null) {
                indexManager = this.createIndexManager(indexManagerName, mappedClass, similarity, indexProp, configuration.getIndexManagerFactory(), context);
            } else {
                if (!indexManager.getSimilarity().getClass().equals(similarity.getClass())) {
                    throw log.getMultipleEntitiesShareIndexWithInconsistentSimilarityException(mappedClass.getName(), similarity.getClass().getName(), indexManager.getContainedTypes().iterator().next().getName(), indexManager.getSimilarity().getClass().getName());
                }
                indexManager.addContainedEntity(mappedClass);
            }
            indexManagers[index] = indexManager;
        }
        return indexManagers;
    }

    private synchronized IndexManager createIndexManager(String indexManagerName, Class<?> mappedClass, Similarity similarity, Properties indexProperties, IndexManagerFactory indexManagerFactory, WorkerBuildContext context) {
        IndexManager indexManager = this.indexManagersRegistry.get(indexManagerName);
        if (indexManager == null) {
            indexManager = this.createIndexManager(indexManagerName, similarity, indexManagerFactory, indexProperties, context);
            this.indexManagersRegistry.put(indexManagerName, indexManager);
        }
        indexManager.addContainedEntity(mappedClass);
        return indexManager;
    }

    private boolean isShardingDynamic(Properties indexProperty) {
        Class shardingStrategy;
        boolean isShardingDynamic = false;
        String shardingStrategyName = indexProperty.getProperty(SHARDING_STRATEGY);
        if (shardingStrategyName == null) {
            return isShardingDynamic;
        }
        try {
            shardingStrategy = ClassLoaderHelper.classForName(shardingStrategyName, DirectoryProviderFactory.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw log.getUnableToLoadShardingStrategyClassException(shardingStrategyName);
        }
        if (ShardIdentifierProvider.class.isAssignableFrom(shardingStrategy)) {
            isShardingDynamic = true;
        }
        return isShardingDynamic;
    }
}

