/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.analyzerdefs;

import java.util.LinkedHashSet;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.assertj.core.api.Assertions;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.engine.impl.AnalyzerRegistry;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.integration.impl.SearchIntegration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class AnalyzerDefsAnnotationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(Sample.class);
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void shouldBePossibleToAnnotatePackage() throws Exception {
        this.assertThatAnalyzerExists("package-analyzer-1");
        this.assertThatAnalyzerExists("package-analyzer-2");
    }

    @Test
    public void shouldBePossibleToAnnotateClass() throws Exception {
        this.assertThatAnalyzerExists("class-analyzer-1");
        this.assertThatAnalyzerExists("class-analyzer-2");
    }

    @Test
    public void shouldContainTheDefinedAnalyzers() throws Exception {
        ExtendedSearchIntegrator factory = this.sfHolder.getSearchFactory();
        LinkedHashSet analyzerNames = new LinkedHashSet();
        for (SearchIntegration integration : factory.getIntegrations().values()) {
            AnalyzerRegistry registry = integration.getAnalyzerRegistry();
            analyzerNames.addAll(registry.getNamedAnalyzerReferences().keySet());
        }
        Assertions.assertThat(analyzerNames).contains((Object[])new String[]{"package-analyzer-1", "package-analyzer-2", "class-analyzer-1", "class-analyzer-2"});
    }

    @Test
    public void shouldNotBePossibleToHaveTwoAnalyzerDefsWithTheSameName() throws Exception {
        this.thrown.expect(SearchException.class);
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(SampleWithError.class);
        this.integratorResource.create(cfg);
    }

    private void assertThatAnalyzerExists(String analyzerName) {
        for (SearchIntegration integration : this.sfHolder.getSearchFactory().getIntegrations().values()) {
            AnalyzerRegistry registry = integration.getAnalyzerRegistry();
            AnalyzerReference analyzerReference = registry.getAnalyzerReference(analyzerName);
            if (analyzerReference == null) continue;
            if (analyzerReference.is(LuceneAnalyzerReference.class)) {
                Assertions.assertThat((Object)((LuceneAnalyzerReference)analyzerReference.unwrap(LuceneAnalyzerReference.class)).getAnalyzer()).isNotNull();
            }
            return;
        }
        Assert.fail((String)("Analyzer does not exist: " + analyzerName));
    }

    @Indexed
    @AnalyzerDefs(value={@AnalyzerDef(name="package-analyzer-1", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class)), @AnalyzerDef(name="class-analyzer-unique", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))})
    static class SampleWithError {
        @DocumentId
        final long id = 1L;
        @Field
        final String description = "";

        SampleWithError() {
        }
    }

    @Indexed
    @AnalyzerDefs(value={@AnalyzerDef(name="class-analyzer-1", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class)), @AnalyzerDef(name="class-analyzer-2", tokenizer=@TokenizerDef(factory=StandardTokenizerFactory.class))})
    static class Sample {
        @DocumentId
        long id;
        @Field
        String description;

        Sample() {
        }
    }
}

