/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.bridge.time;

import java.time.MonthDay;
import org.assertj.core.api.Assertions;
import org.hibernate.search.bridge.builtin.time.impl.MonthDayBridge;
import org.junit.Test;

public class MonthDayBridgeTest {
    private static final MonthDayBridge BRIDGE = MonthDayBridge.INSTANCE;
    private static final MonthDay MAX_VALUE = MonthDay.of(12, 31);
    private static final MonthDay MIN_VALUE = MonthDay.of(1, 1);
    private static final MonthDay CUSTOM_VALUE = MonthDay.of(1, 4);
    private static final String MAX = "1231";
    private static final String MIN = "0101";
    private static final String CST = "0104";

    @Test
    public void testMaxObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MAX_VALUE)).isEqualTo((Object)MAX);
    }

    @Test
    public void testMinObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)MIN_VALUE)).isEqualTo((Object)MIN);
    }

    @Test
    public void testPaddingObjectToString() throws Exception {
        Assertions.assertThat((String)BRIDGE.objectToString((Object)CUSTOM_VALUE)).isEqualTo((Object)CST);
    }

    @Test
    public void testMaxStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MAX)).isEqualTo((Object)MAX_VALUE);
    }

    @Test
    public void testMinStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(MIN)).isEqualTo((Object)MIN_VALUE);
    }

    @Test
    public void testPaddingStringToObject() throws Exception {
        Assertions.assertThat((Object)BRIDGE.stringToObject(CST)).isEqualTo((Object)CUSTOM_VALUE);
    }
}

