/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;

@Indexed
@AnalyzerDefs(value={@AnalyzerDef(name="titleAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=ASCIIFoldingFilterFactory.class)}), @AnalyzerDef(name="authorAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class))})
class Book {
    @DocumentId
    String id;
    @Fields(value={@Field(analyzer=@Analyzer(definition="titleAnalyzer")), @Field(name="title_sort", analyze=Analyze.NO)})
    @SortableField(forField="title_sort")
    private String title;
    @Field(analyzer=@Analyzer(definition="authorAnalyzer"))
    private String author;

    public Book() {
    }

    public Book(String title, String author) {
        this.id = title;
        this.title = title;
        this.author = author;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getAuthor() {
        return this.author;
    }
}

