/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.EncodingType;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class NumericEncodingQueriesTest {
    private static final Calendar ANNOUNCED = NumericEncodingQueriesTest.initCalendar(1950, 1, 1);
    private static final Date UPDATED = NumericEncodingQueriesTest.initCalendar(2000, 1, 1).getTime();
    private static final Calendar FIRST_EDITION = NumericEncodingQueriesTest.initCalendar(1966, 0, 1);
    private static final Calendar NEXT_EVENT = NumericEncodingQueriesTest.initCalendar(2015, 9, 29);
    private static final long LUCCA_ID = 1L;
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Fair.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    private static Calendar initCalendar(int year, int month, int day) {
        Calendar instance = NumericEncodingQueriesTest.createCalendar();
        instance.set(1966, 0, 1);
        return instance;
    }

    private static Calendar createCalendar() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Rome"), Locale.ITALY);
        calendar.setTimeInMillis(0L);
        return calendar;
    }

    @Before
    public void createEvent() throws Exception {
        Fair lucca = new Fair(1L, "Lucca comics and games", NEXT_EVENT.getTime(), FIRST_EDITION, UPDATED, ANNOUNCED);
        this.helper.add(lucca);
    }

    @Test
    public void testDslWithDate() throws Exception {
        Date nextEventDate = DateTools.round((Date)NEXT_EVENT.getTime(), (DateTools.Resolution)DateTools.Resolution.DAY);
        Query query = this.queryBuilder().keyword().onField("startDate").matching((Object)nextEventDate).createQuery();
        this.helper.assertThat(query).from(Fair.class).matchesExactlyIds(Long.valueOf(1L));
    }

    @Test
    public void testDslWithCalendar() throws Exception {
        Calendar year = NumericEncodingQueriesTest.createCalendar();
        year.setTime(DateTools.round((Date)FIRST_EDITION.getTime(), (DateTools.Resolution)DateTools.Resolution.YEAR));
        Query query = this.queryBuilder().keyword().onField("since").matching((Object)year).createQuery();
        this.helper.assertThat(query).from(Fair.class).matchesExactlyIds(Long.valueOf(1L));
    }

    @Test
    public void testDslWithDefaultDateBridge() throws Exception {
        Query query = this.queryBuilder().keyword().onField("updated").matching((Object)UPDATED).createQuery();
        this.helper.assertThat(query).from(Fair.class).matchesExactlyIds(Long.valueOf(1L));
    }

    @Test
    public void testDslWithDefaultCalendarBridge() throws Exception {
        Query query = this.queryBuilder().keyword().onField("announced").matching((Object)ANNOUNCED).createQuery();
        this.helper.assertThat(query).from(Fair.class).matchesExactlyIds(Long.valueOf(1L));
    }

    private QueryBuilder queryBuilder() {
        return this.helper.queryBuilder(Fair.class);
    }

    @Indexed
    private static class Fair {
        @DocumentId
        private Long id;
        @Field
        private String name;
        @Field
        @DateBridge(encoding=EncodingType.NUMERIC, resolution=Resolution.DAY)
        private Date startDate;
        @Field
        @CalendarBridge(encoding=EncodingType.NUMERIC, resolution=Resolution.YEAR)
        private Calendar since;
        @Field
        private Date updated;
        @Field
        private Calendar announced;

        public Fair(Long id, String name, Date startDate, Calendar since, Date updated, Calendar announced) {
            this.id = id;
            this.name = name;
            this.startDate = startDate;
            this.since = since;
            this.updated = updated;
            this.announced = announced;
        }
    }
}

