/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.metadata;

import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.impl.ConfigContext;
import org.hibernate.search.engine.metadata.impl.AnnotationMetadataProvider;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.FieldSettingsDescriptor;
import org.hibernate.search.metadata.IndexedTypeDescriptor;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.test.metadata.DescriptorTestHelper;
import org.hibernate.search.test.metadata.Snafu;
import org.hibernate.search.test.metadata.SnafuWithCoordinates;
import org.hibernate.search.test.metadata.SnafuWithCoordinatesWithoutSpatial;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.analyzer.FooAnalyzer;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.util.impl.PassThroughAnalyzer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-436")
public class FieldDescriptorTest {
    private AnnotationMetadataProvider metadataProvider;

    @Before
    public void setUp() {
        SearchConfigurationForTest searchConfiguration = new SearchConfigurationForTest();
        ConfigContext configContext = new ConfigContext((SearchConfiguration)searchConfiguration, (BuildContext)new BuildContextForTest(searchConfiguration));
        this.metadataProvider = new AnnotationMetadataProvider((ReflectionManager)new JavaReflectionManager(), configContext);
    }

    @Test
    public void testFieldDescriptorLuceneOptions() {
        String fieldName = "my-snafu";
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, fieldName);
        Assert.assertEquals((String)"Wrong field name", (Object)fieldName, (Object)fieldDescriptor.getName());
        Assert.assertEquals((Object)Index.NO, (Object)fieldDescriptor.getIndex());
        Assert.assertEquals((Object)Analyze.NO, (Object)fieldDescriptor.getAnalyze());
        Assert.assertEquals((Object)Store.YES, (Object)fieldDescriptor.getStore());
        Assert.assertEquals((Object)Norms.NO, (Object)fieldDescriptor.getNorms());
        Assert.assertEquals((Object)TermVector.WITH_POSITIONS, (Object)fieldDescriptor.getTermVector());
        Assert.assertEquals((float)10.0f, (float)fieldDescriptor.getBoost(), (float)0.0f);
        Assert.assertFalse((boolean)fieldDescriptor.indexNull());
        Assert.assertNull((Object)fieldDescriptor.indexNullAs());
        Assert.assertTrue((boolean)FieldSettingsDescriptor.Type.BASIC.equals((Object)fieldDescriptor.getType()));
    }

    @Test
    public void testFieldDescriptorDefaultNullIndexOptions() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "my-snafu");
        Assert.assertFalse((boolean)fieldDescriptor.indexNull());
        Assert.assertNull((Object)fieldDescriptor.indexNullAs());
    }

    @Test
    public void testFieldDescriptorNullIndexOptions() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "nullValue");
        Assert.assertTrue((boolean)fieldDescriptor.indexNull());
        Assert.assertEquals((Object)"snafu", (Object)fieldDescriptor.indexNullAs());
    }

    @Test
    public void testCastingNonNumericFieldDescriptorToNumericOneThrowsException() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "my-snafu");
        Assert.assertFalse((boolean)FieldSettingsDescriptor.Type.NUMERIC.equals((Object)fieldDescriptor.getType()));
        try {
            fieldDescriptor.as(NumericFieldSettingsDescriptor.class);
            Assert.fail((String)"A basic field descriptor cannot be narrowed to a numeric one");
        }
        catch (ClassCastException e) {
            Assert.assertTrue((String)("Wrong exception: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000180"));
        }
    }

    @Test
    public void testFieldDescriptorAsWithNullParameterThrowsException() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "my-snafu");
        try {
            fieldDescriptor.as(null);
            Assert.fail((String)"null is not a valid type");
        }
        catch (ClassCastException e) {
            Assert.assertTrue((String)("Wrong exception: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000180"));
        }
    }

    @Test
    public void testFieldDescriptorExplicitNumericOptions() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "numericField");
        Assert.assertTrue((boolean)FieldSettingsDescriptor.Type.NUMERIC.equals((Object)fieldDescriptor.getType()));
        NumericFieldSettingsDescriptor numericFieldSettingsDescriptor = (NumericFieldSettingsDescriptor)fieldDescriptor.as(NumericFieldSettingsDescriptor.class);
        int expectedPrecisionStep = 16;
        Assert.assertEquals((String)("the numeric step should be " + expectedPrecisionStep), (long)expectedPrecisionStep, (long)numericFieldSettingsDescriptor.precisionStep());
        NumericFieldSettingsDescriptor.NumericEncodingType expectedNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
        Assert.assertEquals((String)("the numeric field should be encoded as " + expectedNumericEncodingType), (Object)expectedNumericEncodingType, (Object)numericFieldSettingsDescriptor.encodingType());
    }

    @Test
    public void testFieldDescriptorWithCoordinates() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(SnafuWithCoordinates.class, "location");
        Assert.assertNotNull((Object)fieldDescriptor.getFieldBridge());
        Assert.assertTrue((boolean)(fieldDescriptor.getFieldBridge() instanceof SpatialFieldBridge));
        Assert.assertTrue((boolean)FieldSettingsDescriptor.Type.SPATIAL.equals((Object)fieldDescriptor.getType()));
    }

    @Test
    public void testFieldDescriptorWithCoordinatesWithoutSpatialAnnotation() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(SnafuWithCoordinatesWithoutSpatial.class, "location");
        Assert.assertNotNull((Object)fieldDescriptor.getFieldBridge());
        Assert.assertTrue((boolean)(fieldDescriptor.getFieldBridge() instanceof SpatialFieldBridge));
        Assert.assertEquals((Object)FieldSettingsDescriptor.Type.SPATIAL, (Object)fieldDescriptor.getType());
    }

    @Test
    public void testFieldDescriptorSpatialFieldBridge() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "location");
        Assert.assertNotNull((Object)fieldDescriptor.getFieldBridge());
        Assert.assertTrue((boolean)(fieldDescriptor.getFieldBridge() instanceof SpatialFieldBridge));
        Assert.assertTrue((boolean)FieldSettingsDescriptor.Type.SPATIAL.equals((Object)fieldDescriptor.getType()));
    }

    @Test
    public void testFieldDescriptorDefaultAnalyzer() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "my-snafu");
        Assert.assertNotNull((Object)fieldDescriptor.getAnalyzer());
        Assert.assertTrue((boolean)(fieldDescriptor.getAnalyzer() instanceof PassThroughAnalyzer));
    }

    @Test
    public void testFieldDescriptorExplicitAnalyzer() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "custom");
        Assert.assertNotNull((Object)fieldDescriptor.getAnalyzer());
        Assert.assertTrue((boolean)(fieldDescriptor.getAnalyzer() instanceof FooAnalyzer));
    }

    @Test
    public void testFieldDescriptorDefaultFieldBridge() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "my-snafu");
        Assert.assertNotNull((Object)fieldDescriptor.getFieldBridge());
        Assert.assertTrue((boolean)(fieldDescriptor.getFieldBridge() instanceof StringBridge));
    }

    @Test
    public void testFieldDescriptorShortNumericFieldBridge() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "numericShortField");
        Assert.assertNotNull((Object)fieldDescriptor.getFieldBridge());
        Assert.assertTrue((boolean)(fieldDescriptor.getFieldBridge() instanceof NumericFieldBridge));
        Assert.assertTrue((boolean)FieldSettingsDescriptor.Type.NUMERIC.equals((Object)fieldDescriptor.getType()));
        NumericFieldSettingsDescriptor numericFieldSettingsDescriptor = (NumericFieldSettingsDescriptor)fieldDescriptor.as(NumericFieldSettingsDescriptor.class);
        int expectedPrecisionStep = 8;
        Assert.assertEquals((String)("the numeric step should be " + expectedPrecisionStep), (long)expectedPrecisionStep, (long)numericFieldSettingsDescriptor.precisionStep());
        NumericFieldSettingsDescriptor.NumericEncodingType expectedNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
        Assert.assertEquals((String)("the short numeric field should be encoded as " + expectedNumericEncodingType), (Object)expectedNumericEncodingType, (Object)numericFieldSettingsDescriptor.encodingType());
    }

    @Test
    public void testFieldDescriptorByteNumericFieldBridge() {
        FieldDescriptor fieldDescriptor = this.getFieldDescriptor(Snafu.class, "numericByteField");
        Assert.assertNotNull((Object)fieldDescriptor.getFieldBridge());
        Assert.assertTrue((boolean)(fieldDescriptor.getFieldBridge() instanceof NumericFieldBridge));
        Assert.assertTrue((boolean)FieldSettingsDescriptor.Type.NUMERIC.equals((Object)fieldDescriptor.getType()));
        NumericFieldSettingsDescriptor numericFieldSettingsDescriptor = (NumericFieldSettingsDescriptor)fieldDescriptor.as(NumericFieldSettingsDescriptor.class);
        int expectedPrecisionStep = 4;
        Assert.assertEquals((String)("the numeric step should be " + expectedPrecisionStep), (long)expectedPrecisionStep, (long)numericFieldSettingsDescriptor.precisionStep());
        NumericFieldSettingsDescriptor.NumericEncodingType expectedNumericEncodingType = NumericFieldSettingsDescriptor.NumericEncodingType.INTEGER;
        Assert.assertEquals((String)("the short numeric field should be encoded as " + expectedNumericEncodingType), (Object)expectedNumericEncodingType, (Object)numericFieldSettingsDescriptor.encodingType());
    }

    private FieldDescriptor getFieldDescriptor(Class<?> clazz, String fieldName) {
        IndexedTypeDescriptor typeDescriptor = DescriptorTestHelper.getTypeDescriptor(this.metadataProvider, clazz);
        return typeDescriptor.getIndexedField(fieldName);
    }
}

