/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.analyzer.inheritance;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.analyzer.common.AnalyzerTest;
import org.hibernate.search.test.analyzer.inheritance.SubClass;
import org.hibernate.search.testsupport.TestConstants;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.util.AnalyzerUtils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

public class AnalyzerInheritanceTest {
    private static final IndexedTypeIdentifier SUB_CLASS_TYPE_ID = PojoIndexedTypeIdentifier.convertFromLegacy(SubClass.class);
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(SubClass.class).withProperty("hibernate.search.analyzer", KeywordAnalyzer.class.getName());
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void testBySearch() throws Exception {
        SubClass testClass = new SubClass(1);
        testClass.setName("I\u0307stanbul");
        this.helper.index(testClass);
        QueryParser parser = new QueryParser("name", TestConstants.keywordAnalyzer);
        Query luceneQuery = parser.parse("name:istanbul");
        this.helper.assertThat(luceneQuery).from(SubClass.class).matchesExactlyIds(Integer.valueOf(1));
        luceneQuery = parser.parse("name:foo");
        this.helper.assertThat(luceneQuery).from(SubClass.class).matchesNone();
    }

    @Test
    @Category(value={SkipOnElasticsearch.class})
    public void testByAnalyzerRetrieval() throws Exception {
        Analyzer analyzer = this.sfHolder.getSearchFactory().getAnalyzer(SUB_CLASS_TYPE_ID);
        Token[] tokens = AnalyzerUtils.tokensFromAnalysis((Analyzer)analyzer, (String)"name", (String)"I\u0307stanbul");
        AnalyzerTest.assertTokensEqual(tokens, new String[]{"istanbul"});
    }
}

