/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport.textbuilder;

import java.util.Locale;
import java.util.Random;
import java.util.TreeSet;
import org.hibernate.search.testsupport.textbuilder.WordDictionary;

public class SentenceInventor {
    private final Random r;
    private final WordDictionary dictionary;
    private final Locale randomlocale;
    private final char[] sentenceSeparators = new char[]{',', ',', ',', ';', ':', ':'};
    private final char[] periodSeparators = new char[]{'.', '.', '.', '.', '.', '?', '?', '!'};

    public SentenceInventor(long randomSeed, int dictionarySize) {
        this.r = new Random(randomSeed);
        this.randomlocale = this.randomLocale();
        this.dictionary = this.randomDictionary(dictionarySize);
    }

    private Locale randomLocale() {
        Locale[] availableLocales = Locale.getAvailableLocales();
        int index = this.r.nextInt(availableLocales.length);
        return availableLocales[index];
    }

    public char randomCharacter() {
        return (char)(this.r.nextInt(26) + 65);
    }

    public String randomString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = this.randomCharacter();
        }
        return new String(chars);
    }

    public String randomString() {
        double d = this.r.nextGaussian() * 6.3;
        int l = (int)d + 6;
        if (l > 0) {
            return this.randomString(l);
        }
        return this.randomString();
    }

    public String randomTerm() {
        int i = this.r.nextInt(200);
        String term = this.randomString();
        if (i > 10) {
            return term.toLowerCase(this.randomlocale);
        }
        if (i < 2) {
            return term;
        }
        return term.substring(0, 1) + term.substring(1).toLowerCase(this.randomlocale);
    }

    private WordDictionary randomDictionary(int size) {
        TreeSet<String> tree = new TreeSet<String>();
        while (tree.size() != size) {
            tree.add(this.randomTerm());
        }
        return new WordDictionary(tree);
    }

    public String nextSentence() {
        int sentenceLength = this.r.nextInt(3) + this.r.nextInt(10) + 1;
        String[] sentence = new String[sentenceLength];
        for (int i = 0; i < sentenceLength; ++i) {
            sentence[i] = this.dictionary.randomWord();
        }
        if (sentenceLength == 1) {
            return sentence[0];
        }
        StringBuilder sb = new StringBuilder(sentence[0]);
        for (int i = 1; i < sentenceLength; ++i) {
            sb.append(" ");
            sb.append(sentence[i]);
        }
        return sb.toString();
    }

    public String nextPeriod() {
        int periodLengthSentences = this.r.nextInt(6) + this.r.nextInt(4) - 3;
        periodLengthSentences = periodLengthSentences < 1 ? 1 : periodLengthSentences;
        String firstsentence = this.nextSentence();
        StringBuilder sb = new StringBuilder().append(firstsentence.substring(0, 1).toUpperCase(this.randomlocale)).append(firstsentence.substring(1));
        for (int i = 1; i < periodLengthSentences; ++i) {
            int separatorCharIndex = this.r.nextInt(this.sentenceSeparators.length);
            sb.append(this.sentenceSeparators[separatorCharIndex]).append(' ').append(this.nextSentence());
        }
        int periodSeparatorCharIndex = this.r.nextInt(this.periodSeparators.length);
        sb.append(this.periodSeparators[periodSeparatorCharIndex]);
        sb.append("\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        SentenceInventor wi = new SentenceInventor(7L, 10000);
        for (int i = 0; i < 3000; ++i) {
            System.out.print(wi.nextPeriod());
        }
    }
}

