/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import org.apache.lucene.search.MatchAllDocsQuery;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2521")
public class BuildQueryBuilderTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(ConfiguredNotIndexed.class, ConfiguredIndexed.class);

    @Test
    public void forEntity_configured_indexed() {
        QueryBuilder builder = this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(ConfiguredIndexed.class).get();
        Assert.assertEquals((Object)new MatchAllDocsQuery(), (Object)builder.all().createQuery());
    }

    @Test
    public void forEntity_configured_notIndexed() {
        this.thrown.expectMessage("HSEARCH000278");
        this.thrown.expectMessage("indexed");
        this.thrown.expectMessage(ConfiguredNotIndexed.class.getSimpleName());
        this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(ConfiguredNotIndexed.class).get();
    }

    @Test
    public void forEntity_notConfigured_indexed() {
        this.thrown.expectMessage("HSEARCH000331");
        this.thrown.expectMessage("configured");
        this.thrown.expectMessage(NotConfiguredIndexed.class.getSimpleName());
        this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(NotConfiguredIndexed.class).get();
    }

    @Test
    public void forEntity_notConfigured_notIndexed() {
        this.thrown.expectMessage("HSEARCH000331");
        this.thrown.expectMessage("configured");
        this.thrown.expectMessage(NotConfiguredNotIndexed.class.getSimpleName());
        this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(NotConfiguredNotIndexed.class).get();
    }

    @Indexed
    private static class NotConfiguredIndexed {
        @DocumentId
        private int id;
        @Field
        private String field;

        private NotConfiguredIndexed() {
        }
    }

    private static class NotConfiguredNotIndexed {
        @DocumentId
        private int id;
        @Field
        private String field;

        private NotConfiguredNotIndexed() {
        }
    }

    @Indexed
    private static class ConfiguredIndexed {
        @DocumentId
        private int id;
        @Field
        private String field;

        private ConfiguredIndexed() {
        }
    }

    private static class ConfiguredNotIndexed {
        @DocumentId
        private int id;
        @Field
        private String field;

        private ConfiguredNotIndexed() {
        }
    }
}

