/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.ObjectAssert;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.MoreLikeThisOpenedMatchingContext;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.test.dsl.Coffee;
import org.hibernate.search.test.dsl.CoffeeBrand;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class MoreLikeThisTest {
    private static final Log log = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Coffee.class, CoffeeBrand.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);
    private final boolean outputLogs = false;
    private Coffee decaffInstance;
    private Coffee kazaarInstance;

    @Before
    public void setUp() throws Exception {
        this.indexTestData();
    }

    @Test
    public void testMoreLikeThisBasicBehavior() throws Exception {
        QueryBuilder qb = this.getCoffeeQueryBuilder();
        Query mltQuery = qb.moreLikeThis().favorSignificantTermsWithFactor(1.0f).comparingAllFields().toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        List<Object[]> results = this.doQuery(mltQuery);
        Assertions.assertThat(results).isNotEmpty();
        Set<Term> terms = this.extractTerms(mltQuery, Coffee.class);
        ((IterableAssert)Assertions.assertThat(terms).describedAs("internalDescription should be ignored", new Object[0])).extracting(t -> t.field()).doesNotContain((Object[])new String[]{"internalDescription"});
        this.outputQueryAndResults(this.decaffInstance, mltQuery, results);
        mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        results = this.doQuery(mltQuery);
        Assertions.assertThat(results).isNotEmpty();
        Assertions.assertThat((boolean)(mltQuery instanceof BooleanQuery));
        BooleanQuery topMltQuery = (BooleanQuery)mltQuery;
        Assertions.assertThat((List)topMltQuery.clauses()).extracting("query.boost").contains(new Object[]{Float.valueOf(1.0f), Float.valueOf(10.0f)});
        this.outputQueryAndResults(this.decaffInstance, mltQuery, results);
        try {
            qb.moreLikeThis().comparingField("summary").andField("internalDescription").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        }
        catch (SearchException e) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)e.getMessage()).as("Internal description is neither stored nor store termvectors", new Object[0])).contains(new CharSequence[]{"internalDescription"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Term> extractTerms(Query query, Class<?> indexedType) throws IOException {
        try (IndexReader reader = null;){
            HashSet<Term> terms = new HashSet<Term>(100);
            reader = this.sfHolder.getSearchFactory().getIndexReaderAccessor().open(new Class[]{indexedType});
            query.createWeight(new IndexSearcher(reader), false).extractTerms(terms);
            HashSet<Term> hashSet = terms;
            return hashSet;
        }
    }

    @Test
    public void testMoreLikeThisToEntity() {
        Object[] expected;
        Object[] real;
        int index;
        QueryBuilder qb = this.getCoffeeQueryBuilder();
        Query mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        List<Object[]> results = this.doQuery(mltQuery);
        mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntity((Object)this.decaffInstance).createQuery();
        List<Object[]> entityResults = this.doQuery(mltQuery);
        Assertions.assertThat(entityResults).isNotEmpty();
        Assertions.assertThat(entityResults).hasSize(results.size());
        for (int index2 = 0; index2 < entityResults.size(); ++index2) {
            Object[] real2 = entityResults.get(index2);
            Object[] expected2 = results.get(index2);
            Assertions.assertThat((Object)real2[1]).isEqualTo(expected2[1]);
            Assertions.assertThat((Object)real2[0]).isEqualTo(expected2[0]);
        }
        this.outputQueryAndResults(this.decaffInstance, mltQuery, entityResults);
        Coffee nonMatchingOne = this.kazaarInstance;
        Coffee copyOfDecaffInstance = new Coffee();
        copyOfDecaffInstance.setId(this.decaffInstance.getId());
        copyOfDecaffInstance.setInternalDescription(nonMatchingOne.getInternalDescription());
        copyOfDecaffInstance.setName(nonMatchingOne.getName());
        copyOfDecaffInstance.setDescription(nonMatchingOne.getDescription());
        copyOfDecaffInstance.setIntensity(nonMatchingOne.getIntensity());
        copyOfDecaffInstance.setSummary(nonMatchingOne.getSummary());
        mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntity((Object)copyOfDecaffInstance).createQuery();
        entityResults = this.doQuery(mltQuery);
        Assertions.assertThat(entityResults).isNotEmpty();
        Assertions.assertThat(entityResults).hasSize(results.size());
        for (index = 0; index < entityResults.size(); ++index) {
            real = entityResults.get(index);
            expected = results.get(index);
            Assertions.assertThat((Object)real[1]).isEqualTo(expected[1]);
            Assertions.assertThat((Object)real[0]).isEqualTo(expected[0]);
        }
        this.outputQueryAndResults(this.decaffInstance, mltQuery, entityResults);
        copyOfDecaffInstance = new Coffee();
        copyOfDecaffInstance.setInternalDescription(this.decaffInstance.getInternalDescription());
        copyOfDecaffInstance.setName(this.decaffInstance.getName());
        copyOfDecaffInstance.setDescription(this.decaffInstance.getDescription());
        copyOfDecaffInstance.setIntensity(this.decaffInstance.getIntensity());
        copyOfDecaffInstance.setSummary(this.decaffInstance.getSummary());
        mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntity((Object)copyOfDecaffInstance).createQuery();
        entityResults = this.doQuery(mltQuery);
        Assertions.assertThat(entityResults).isNotEmpty();
        Assertions.assertThat(entityResults).hasSize(results.size());
        for (index = 0; index < entityResults.size(); ++index) {
            real = entityResults.get(index);
            expected = results.get(index);
            Assertions.assertThat((Object)real[1]).isEqualTo(expected[1]);
            Assertions.assertThat((Object)real[0]).isEqualTo(expected[0]);
        }
        this.outputQueryAndResults(this.decaffInstance, mltQuery, entityResults);
    }

    @Test
    public void testMoreLikeThisExcludingEntityBeingCompared() {
        QueryBuilder qb = this.getCoffeeQueryBuilder();
        Query mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        List<Object[]> results = this.doQuery(mltQuery);
        mltQuery = ((MoreLikeThisOpenedMatchingContext)qb.moreLikeThis().excludeEntityUsedForComparison().comparingField("summary").boostedTo(10.0f)).andField("description").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        List<Object[]> resultsWoComparingEntity = this.doQuery(mltQuery);
        Assertions.assertThat(resultsWoComparingEntity).hasSize(results.size() - 1);
        for (int index = 0; index < resultsWoComparingEntity.size(); ++index) {
            Object[] real = resultsWoComparingEntity.get(index);
            Object[] expected = results.get(index + 1);
            Assertions.assertThat((Object)real[1]).isEqualTo(expected[1]);
            Assertions.assertThat((Object)real[0]).isEqualTo(expected[0]);
        }
        this.outputQueryAndResults(this.decaffInstance, mltQuery, resultsWoComparingEntity);
    }

    @Test
    public void testMoreLikeThisOnCompressedFields() {
        QueryBuilder qb = this.getCoffeeQueryBuilder();
        Query mltQuery = qb.moreLikeThis().comparingField("brand.description").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        List<Object[]> entityResults = this.doQuery(mltQuery);
        Assertions.assertThat(entityResults).hasSize(3);
        float score = -1.0f;
        for (Object[] element : entityResults) {
            if (score == -1.0f) {
                score = ((Float)element[1]).floatValue();
            }
            ((ObjectAssert)Assertions.assertThat((Object)element[1]).as("All scores should be equal as the same brand is used", new Object[0])).isEqualTo((Object)Float.valueOf(score));
        }
        this.outputQueryAndResults(this.decaffInstance, mltQuery, entityResults);
    }

    @Test
    public void testMoreLikeThisOnEmbeddedFields() {
        QueryBuilder qb = this.getCoffeeQueryBuilder();
        Query mltQuery = qb.moreLikeThis().comparingField("brand.name").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        List<Object[]> entityResults = this.doQuery(mltQuery);
        Assertions.assertThat(entityResults).hasSize(3);
        float score = -1.0f;
        for (Object[] element : entityResults) {
            if (score == -1.0f) {
                score = ((Float)element[1]).floatValue();
            }
            ((ObjectAssert)Assertions.assertThat((Object)element[1]).as("All scores should be equal as the same brand is used", new Object[0])).isEqualTo((Object)Float.valueOf(score));
        }
        this.outputQueryAndResults(this.decaffInstance, mltQuery, entityResults);
        try {
            qb.moreLikeThis().comparingField("brand.id").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
        }
        catch (SearchException e) {
            ((AbstractCharSequenceAssert)Assertions.assertThat((String)e.getMessage()).as("Field cannot be used", new Object[0])).contains(new CharSequence[]{"brand.id"});
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-1614")
    public void testMoreLikeThisOnUnknownFieldThrowsException() {
        QueryBuilder queryBuilder = this.getCoffeeQueryBuilder();
        try {
            queryBuilder.moreLikeThis().comparingField("foo").toEntityWithId((Object)this.decaffInstance.getId()).createQuery();
            Assert.fail((String)"Creating the query should have failed");
        }
        catch (SearchException e) {
            Assert.assertTrue((String)("Unexpected error message: " + e.getMessage()), (boolean)e.getMessage().startsWith("HSEARCH000218"));
        }
    }

    private QueryBuilder getCoffeeQueryBuilder() {
        return this.helper.queryBuilder(Coffee.class);
    }

    private List<Object[]> doQuery(Query mltQuery) {
        List results = this.helper.hsQuery(mltQuery, Coffee.class).projection(new String[]{"__HSearch_id", "__HSearch_Score"}).queryEntityInfos();
        return results.stream().map(EntityInfo::getProjection).collect(Collectors.toList());
    }

    private void outputQueryAndResults(Coffee originalInstance, Query mltQuery, List<Object[]> results) {
    }

    private void indexTestData() {
        CoffeeBrand brandPony = new CoffeeBrand();
        brandPony.setName("My little pony");
        brandPony.setDescription("Sells goods for horseback riding and good coffee blends");
        CoffeeBrand brandMonkey = new CoffeeBrand();
        brandMonkey.setName("Monkey Monkey Do");
        brandPony.setDescription("Offers mover services via monkeys instead of trucks for difficult terrains. Coffees from this brand make monkeys work much faster.");
        this.kazaarInstance = this.createCoffee("Kazaar", "EXCEPTIONALLY INTENSE AND SYRUPY", "A daring blend of two Robustas from Brazil and Guatemala, specially prepared for Nespresso, and a separately roasted Arabica from South America, Kazaar is a coffee of exceptional intensity. Its powerful bitterness and notes of pepper are balanced by a full and creamy texture.", 12, brandMonkey);
        this.createCoffee("Dharkan", "LONG ROASTED AND VELVETY", "This blend of Arabicas from Latin America and Asia fully unveils its character thanks to the technique of long roasting at a low temperature. Its powerful personality reveals intense roasted notes together with hints of bitter cocoa powder and toasted cereals that express themselves in a silky and velvety txture.", 11, brandPony);
        this.createCoffee("Ristretto", "POWERFUL AND CONTRASTING", "A blend of South American and East African Arabicas, with a touch of Robusta, roasted separately to create the subtle fruity note of this full-bodied, intense espresso.", 10, brandMonkey);
        this.createCoffee("Arpeggio", "INTENSE AND CREAMY", "A dark roast of pure South and Central American Arabicas, Arpeggio has a strong character and intense body, enhanced by cocoa notes.", 9, brandPony);
        this.createCoffee("Roma", "FULL AND BALANCED", "The balance of lightly roasted South and Central American Arabicas with Robusta, gives Roma sweet and woody notes and a full, lasting taste on the palate.", 8, brandMonkey);
        this.createCoffee("Livanto", "ROUND AND BALANCED", "A pure Arabica from South and Central America, Livanto is a well-balanced espresso characterised by a roasted caramelised note.", 6, brandMonkey);
        this.createCoffee("Capriccio", "RICH AND DISTINCTIVE", "Blending South American Arabicas with a touch of Robusta, Capriccio is an espresso with a rich aroma and a strong typical cereal note.", 5, brandMonkey);
        this.createCoffee("Volluto", "SWEET AND LIGHT", "A pure and lightly roasted Arabica from South America, Volluto reveals sweet and biscuity flavours, reinforced by a little acidity and a fruity note.", 4, brandMonkey);
        this.createCoffee("Cosi", "LIGHT AND LEMONY", "Pure, lightly roasted East African, Central and South American Arabicas make Cosi a light-bodied espresso with refreshing citrus notes.", 3, brandMonkey);
        this.createCoffee("Indriya from India", "POWERFUL AND SPICY", "Indriya from India is the noble marriage of Arabicas with a hint of Robusta from southern India. It is a full-bodied espresso, which has a distinct personality with notes of spices.", 10, brandMonkey);
        this.createCoffee("Rosabaya de Colombia", "FRUITY AND BALANCED", "This blend of fine, individually roasted Colombian Arabicas, develops a subtle acidity with typical red fruit and winey notes.", 6, brandMonkey);
        this.createCoffee("Duls\u00e3o do Brasil", "SWEET AND SATINY SMOOTH", "A pure Arabica coffee, Duls\u00e3o do Brasil is a delicate blend of red and yellow Bourbon beans from Brazil. Its satiny smooth, elegantly balanced flavor is enhanced with a note of delicately toasted grain.", 4, brandMonkey);
        this.createCoffee("Bukeela ka Ethiopia", "", "This delicate Lungo expresses a floral bouquet reminiscent of jasmine, white lily, bergamot and orange blossom together with notes of wood. A pure Arabica blend composed of two very different coffees coming from the birthplace of coffee, Ethiopia. The blend\u2019s coffees are roasted separately: one portion short and dark to guarantee the body, the other light but longer to preserve the delicate notes.", 3, brandMonkey);
        this.createCoffee("Fortissio Lungo", "RICH AND INTENSE", "Made from Central and South American Arabicas with just a hint of Robusta, Fortissio Lungo is an intense full-bodied blend with bitterness, which develops notes of dark roasted beans.", 7, brandMonkey);
        this.createCoffee("Vivalto Lungo", "COMPLEX AND BALANCED", "Vivalto Lungo is a balanced coffee made from a complex blend of separately roasted South American and East African Arabicas, combining roasted and subtle floral notes.", 4, brandMonkey);
        this.createCoffee("Linizio Lungo", "ROUND AND SMOOTH", "Mild and well-rounded on the palate, Linizio Lungo is a blend of fine Arabicas enhancing malt and cereal notes.", 4, brandMonkey);
        this.createCoffee("Decaffeinato Intenso", "DENSE AND POWERFUL", "Dark roasted South American Arabicas with a touch of Robusta bring out the subtle cocoa and roasted cereal notes of this full-bodied decaffeinated espresso.", 7, brandMonkey);
        this.createCoffee("Decaffeinato Lungo", "LIGHT AND FULL-FLAVOURED", "The slow roasting of this blend of South American Arabicas with a touch of Robusta gives Decaffeinato Lungo a smooth, creamy body and roasted cereal flavour.", 3, brandMonkey);
        this.decaffInstance = this.createCoffee("Decaffeinato", "FRUITY AND DELICATE", "A blend of South American Arabicas reinforced with just a touch of Robusta is lightly roasted to reveal an aroma of red fruit.", 2, brandPony);
        this.createCoffee("Caramelito", "CARAMEL FLAVOURED", "The sweet flavour of caramel softens the roasted notes of the Livanto Grand Cru. This delicate gourmet marriage evokes the creaminess of soft toffee.", 6, brandMonkey);
        this.createCoffee("Ciocattino", "CHOCOLATE FLAVOURED", "Dark and bitter chocolate notes meet the caramelized roast of the Livanto Grand Cru. A rich combination reminiscent of a square of dark chocolate.", 6, brandMonkey);
        this.createCoffee("Vanilio", "VANILLA FLAVOURED", "A balanced harmony between the rich and the velvety aromas of vanilla and the mellow flavour of the Livanto Grand Cru. A blend distinguished by its full flavour, infinitely smooth and silky on the palate.", 6, brandMonkey);
    }

    private Coffee createCoffee(String title, String summary, String description, int intensity, CoffeeBrand brand) {
        Coffee coffee = new Coffee();
        coffee.setId(title);
        coffee.setName(title);
        coffee.setSummary(summary);
        coffee.setDescription(description);
        coffee.setIntensity(intensity);
        coffee.setInternalDescription("Same internal description of coffee and blend that would make things look quite the same.");
        coffee.setBrand(brand);
        this.helper.add(coffee);
        return coffee;
    }
}

