/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.query.serialization;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.junit.ElasticsearchSupportInProgress;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.junit.SearchITHelper;
import org.hibernate.search.testsupport.serialization.SerializationTestHelper;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ElasticsearchSupportInProgress.class})
public class QuerySerializationTest {
    @Rule
    public final SearchFactoryHolder sfHolder = new SearchFactoryHolder(Book.class);
    private final SearchITHelper helper = new SearchITHelper(this.sfHolder);

    @Test
    public void serializeDeserializeLuceneHSQuery() throws ClassNotFoundException, IOException {
        ExtendedSearchIntegrator integrator = this.sfHolder.getSearchFactory();
        Book book = new Book();
        book.title = "Java Serialization";
        book.text = "The black art of object serialization is full of pitfalls even for experienced developers";
        this.helper.add(book);
        QueryBuilder queryBuilder = integrator.buildQueryBuilder().forEntity(Book.class).get();
        Query luceneQuery = queryBuilder.keyword().onField("text").matching((Object)"art").createQuery();
        HSQuery hsQuery = integrator.createHSQuery(luceneQuery, new Class[]{Book.class});
        hsQuery.luceneQuery(null);
        HSQuery clonedQuery = SerializationTestHelper.duplicateBySerialization(hsQuery);
        clonedQuery.afterDeserialise((SearchIntegrator)integrator);
        clonedQuery.luceneQuery(luceneQuery);
        List result = clonedQuery.queryEntityInfos();
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Indexed
    static class Book {
        @DocumentId
        String title;
        @Field
        String text;

        Book() {
        }
    }
}

