/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.sharding;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.filter.FullTextFilterImplementor;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.ShardIdentifierProvider;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1429")
public class LogRotationExampleTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(LogMessage.class).withProperty("hibernate.search.logs.sharding_strategy", LogMessageShardingStrategy.class.getName());

    @Test
    public void filtersTest() {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder());
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 21, 33), "implementing method makeTimestamp");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 21, 35), "implementing method storeLog");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 15, 15), "Infinispan team meeting");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 7, 30), "reading another bit from Mordechai Ben-Ari");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 9, 0), "email nightmare begins");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 9, 50), "sync-up with Davide");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 10, 0), "first cofee. At Costa!");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 10, 10), "sync-up with Gunnar and Hardy");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 10, 20), "Checking JIRA state for Hibernate Search release plans");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 10, 30), "Check my Infinispan pull requests from the weekend, cleanup git branches");
        this.storeLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 22, 0), "Implementing LogMessageShardingStrategy");
        QueryBuilder logsQueryBuilder = searchFactory.buildQueryBuilder().forEntity(LogMessage.class).get();
        Query allLogs = logsQueryBuilder.all().createQuery();
        Assert.assertEquals((long)11L, (long)this.queryAndFilter(allLogs, 0, 24));
        Assert.assertEquals((long)0L, (long)this.queryAndFilter(allLogs, 2, 5));
        Assert.assertEquals((long)1L, (long)this.queryAndFilter(allLogs, 2, 8));
        Assert.assertEquals((long)3L, (long)this.queryAndFilter(allLogs, 0, 10));
        this.deleteLog(LogRotationExampleTest.makeTimestamp(2013, 10, 7, 9, 0));
        Assert.assertEquals((long)10L, (long)this.queryAndFilter(allLogs, 0, 24));
        Assert.assertEquals((long)24L, (long)searchFactory.getIndexManagerHolder().getIndexManagers().size());
    }

    private int queryAndFilter(Query luceneQuery, int fromHour, int toHour) {
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        HSQuery hsQuery = searchFactory.createHSQuery().luceneQuery(luceneQuery).targetedEntities(Arrays.asList(LogMessage.class));
        hsQuery.enableFullTextFilter("timeRange").setParameter("from", (Object)fromHour).setParameter("to", (Object)toHour);
        return hsQuery.queryResultSize();
    }

    private void storeLog(long timestamp, String message) {
        LogMessage log = new LogMessage();
        log.timestamp = timestamp;
        log.message = message;
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Work work = new Work((Object)log, (Serializable)Long.valueOf(log.timestamp), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private void deleteLog(long timestamp) {
        LogMessage log = new LogMessage();
        log.timestamp = timestamp;
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        Work work = new Work(LogMessage.class, (Serializable)Long.valueOf(log.timestamp), WorkType.DELETE);
        TransactionContextForTest tc = new TransactionContextForTest();
        searchFactory.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private static long makeTimestamp(int year, int month, int date, int hourOfDay, int minute) {
        Calendar gmtCalendar = LogRotationExampleTest.createGMTCalendar();
        gmtCalendar.set(year, month, date, hourOfDay, minute);
        gmtCalendar.set(13, 0);
        gmtCalendar.set(14, 0);
        return gmtCalendar.getTimeInMillis();
    }

    private static String fromIdToHour(long millis) {
        Calendar gmtCalendar = LogRotationExampleTest.createGMTCalendar();
        gmtCalendar.setTimeInMillis(millis);
        return String.valueOf(gmtCalendar.get(11));
    }

    private static Calendar createGMTCalendar() {
        return Calendar.getInstance(TimeZone.getTimeZone("GMT"));
    }

    @Indexed(index="logs")
    @FullTextFilterDef(name="timeRange", impl=ShardSensitiveOnlyFilter.class)
    public static final class LogMessage {
        private long timestamp;
        private String message;

        @DocumentId
        public long getId() {
            return this.timestamp;
        }

        public void setId(long id) {
            this.timestamp = id;
        }

        @Field
        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }

    public static final class LogMessageShardingStrategy
    implements ShardIdentifierProvider {
        private Set<String> hoursOfDay;

        public void initialize(Properties properties, BuildContext buildContext) {
            HashSet<String> hours = new HashSet<String>(24);
            for (int hour = 0; hour < 24; ++hour) {
                hours.add(String.valueOf(hour));
            }
            this.hoursOfDay = Collections.unmodifiableSet(hours);
        }

        public String getShardIdentifier(Class<?> entityType, Serializable id, String idAsString, Document document) {
            return LogRotationExampleTest.fromIdToHour((Long)id);
        }

        public Set<String> getShardIdentifiersForQuery(FullTextFilterImplementor[] fullTextFilters) {
            for (FullTextFilterImplementor ftf : fullTextFilters) {
                if (!"timeRange".equals(ftf.getName())) continue;
                Integer from = (Integer)ftf.getParameter("from");
                Integer to = (Integer)ftf.getParameter("to");
                HashSet<String> hours = new HashSet<String>();
                for (int hour = from.intValue(); hour < to; ++hour) {
                    hours.add(String.valueOf(hour));
                }
                return Collections.unmodifiableSet(hours);
            }
            return this.hoursOfDay;
        }

        public Set<String> getAllShardIdentifiers() {
            return this.hoursOfDay;
        }
    }
}

