/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.dsl;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1973")
public class NumericTypeWithNullEncodingTest {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(SomeEntity.class).withProperty("hibernate.search.default_null_token", "-7");

    @Before
    public void prepareTestData() {
        this.storeData("title-one", 1, 1);
        this.storeData("title-two", 2, null);
        this.storeData("title-three", 3, 3);
    }

    @Test
    public void verifyExplicitRangeQuery() {
        Query query = this.getQueryBuilder().range().onField("age").from((Object)1).excludeLimit().to((Object)3).excludeLimit().createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        List<EntityInfo> queryEntityInfos = this.runProjection(query, "title");
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = queryEntityInfos.get(0);
        Assert.assertEquals((Object)"title-two", (Object)entityInfo.getProjection()[0]);
    }

    @Test
    public void verifyExplicitKeywordQuery() {
        Query query = this.getQueryBuilder().keyword().onField("age").matching((Object)2).createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        List<EntityInfo> queryEntityInfos = this.runProjection(query, "title");
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = queryEntityInfos.get(0);
        Assert.assertEquals((Object)"title-two", (Object)entityInfo.getProjection()[0]);
    }

    @Test
    public void verifyCustomNullEncoding() {
        Query query = this.getQueryBuilder().keyword().onField("nullableAge").matching(null).createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        Assert.assertEquals((Object)"[-1 TO -1]", (Object)query.toString("nullableAge"));
        List<EntityInfo> queryEntityInfos = this.runProjection(query, "title");
        Assert.assertEquals((long)1L, (long)queryEntityInfos.size());
        EntityInfo entityInfo = queryEntityInfos.get(0);
        Assert.assertEquals((Object)"title-two", (Object)entityInfo.getProjection()[0]);
    }

    @Test
    public void verifyNullEncoding() {
        Query query = this.getQueryBuilder().keyword().onField("age").matching(null).createQuery();
        Assert.assertTrue((boolean)(query instanceof NumericRangeQuery));
        Assert.assertEquals((Object)"[-7 TO -7]", (Object)query.toString("age"));
        List<EntityInfo> queryEntityInfos = this.runProjection(query, "title");
        Assert.assertEquals((long)0L, (long)queryEntityInfos.size());
    }

    private List<EntityInfo> runProjection(Query query, String fieldName) {
        return this.sfHolder.getSearchFactory().createHSQuery(query, new Class[]{SomeEntity.class}).projection(new String[]{fieldName}).queryEntityInfos();
    }

    private QueryBuilder getQueryBuilder() {
        return this.sfHolder.getSearchFactory().buildQueryBuilder().forEntity(SomeEntity.class).get();
    }

    private void storeData(String title, int value, Integer nullableAge) {
        SomeEntity entry = new SomeEntity();
        entry.title = title;
        entry.age = value;
        entry.nullableAge = nullableAge;
        Work work = new Work((Object)entry, (Serializable)((Object)entry.title), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        this.sfHolder.getSearchFactory().getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    @Indexed
    public static class SomeEntity {
        @DocumentId
        String title;
        @Field(indexNullAs="__DEFAULT_NULL_TOKEN__")
        int age;
        @Field(indexNullAs="-1")
        Integer nullableAge;
    }
}

