/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.testsupport;

import java.util.Deque;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;
import org.junit.Assert;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class BytemanHelper
extends Helper {
    private static final Log log = LoggerFactory.make();
    private static final AtomicInteger counter = new AtomicInteger();
    private static final Deque<String> concurrentStack = new ConcurrentLinkedDeque<String>();

    protected BytemanHelper(Rule rule) {
        super(rule);
    }

    public void sleepASecond() {
        try {
            log.info((Object)"Byteman rule triggered: sleeping a second");
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error((Object)"unexpected interruption", (Throwable)e);
        }
    }

    public void assertBooleanValue(boolean actual, boolean expected) {
        if (actual != expected) {
            Assert.fail((String)"Unexpected boolean value");
        }
    }

    public void countInvocation() {
        log.debug((Object)"Increment call count");
        counter.incrementAndGet();
    }

    public void pushEvent(String message) {
        concurrentStack.add(message);
    }

    public static BytemanAccessor createAccessor() {
        return new BytemanAccessor();
    }

    public static class BytemanAccessor
    implements TestRule {
        private boolean runningAsJUnitRule = false;

        public boolean isEventStackEmpty() {
            this.ensureRunningAsJUnitRule();
            return concurrentStack.isEmpty();
        }

        public String consumeNextRecordedEvent() {
            this.ensureRunningAsJUnitRule();
            try {
                return (String)concurrentStack.removeFirst();
            }
            catch (NoSuchElementException nse) {
                throw new IllegalStateException("Attempted to consume an event, while no events are left on the stack. If it is the first call to this method, check if the Byteman rules are actually being triggered?");
            }
        }

        public int getAndResetInvocationCount() {
            this.ensureRunningAsJUnitRule();
            return counter.getAndSet(0);
        }

        private void ensureRunningAsJUnitRule() {
            if (!this.runningAsJUnitRule) {
                throw new IllegalStateException("Error in test setup: the byteman accessor obtained through BytemanHelper.createAccessor() must be used as a JUnit Rule (see org.junit.Rule).");
            }
        }

        public Statement apply(final Statement base, Description description) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    runningAsJUnitRule = true;
                    try {
                        base.evaluate();
                    }
                    finally {
                        runningAsJUnitRule = false;
                        this.reset();
                    }
                }
            };
        }

        private void reset() {
            concurrentStack.clear();
            counter.set(0);
        }
    }
}

