/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import org.hibernate.search.engine.impl.MutableSearchFactory;
import org.hibernate.search.test.configuration.BaseConfigurationTest;
import org.hibernate.search.testsupport.junit.SkipOnElasticsearch;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipOnElasticsearch.class})
public class IndexMetadataCompleteConfiguredTest
extends BaseConfigurationTest {
    @Test
    public void testDefaultImplementation() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        this.verifyIndexCompleteMetadataOption(true, cfg);
    }

    @Test
    public void testIndexMetadataCompleteFalse() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setIndexMetadataComplete(false);
        this.verifyIndexCompleteMetadataOption(false, cfg);
    }

    @Test
    public void testIndexMetadataCompleteTrue() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.setIndexMetadataComplete(true);
        this.verifyIndexCompleteMetadataOption(true, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyIndexCompleteMetadataOption(boolean expectation, SearchConfigurationForTest cfg) {
        try (MutableSearchFactory sf = this.getMutableSearchFactoryWithSingleEntity(cfg);){
            Assert.assertEquals((Object)expectation, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, BaseConfigurationTest.Document.class).areSingleTermDeletesSafe());
            sf.addClasses(new Class[]{BaseConfigurationTest.Dvd.class, BaseConfigurationTest.Book.class});
            Assert.assertEquals((Object)false, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, BaseConfigurationTest.Dvd.class).areSingleTermDeletesSafe());
            Assert.assertEquals((Object)false, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, BaseConfigurationTest.Document.class).areSingleTermDeletesSafe());
            Assert.assertEquals((Object)expectation, (Object)IndexMetadataCompleteConfiguredTest.extractWorkspace(sf, BaseConfigurationTest.Book.class).areSingleTermDeletesSafe());
        }
    }
}

