/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan;

import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.infinispan.InfinispanDirectoryProvider;
import org.hibernate.search.infinispan.SimpleEmail;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TwoNodesTest {
    private final String to = "spam@hibernate.org";
    private final String messageText = "to get started as a real spam expert, search for 'getting an iphone' on Hibernate forums";
    FullTextSessionBuilder nodea;
    FullTextSessionBuilder nodeb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSomething() {
        Assert.assertEquals((long)2L, (long)this.clusterSize(this.nodea));
        FullTextSession fullTextSession = this.nodea.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        SimpleEmail mail = new SimpleEmail();
        mail.to = "spam@hibernate.org";
        mail.message = "to get started as a real spam expert, search for 'getting an iphone' on Hibernate forums";
        fullTextSession.save((Object)mail);
        transaction.commit();
        fullTextSession.close();
        this.verifyNodeSeesUpdatedIndex(this.nodeb);
        FullTextSessionBuilder nodeC = new FullTextSessionBuilder();
        this.prepareCommonConfiguration(nodeC);
        nodeC.build();
        Assert.assertEquals((long)3L, (long)this.clusterSize(this.nodea));
        try {
            this.verifyNodeSeesUpdatedIndex(nodeC);
        }
        finally {
            nodeC.close();
        }
        Assert.assertEquals((long)2L, (long)this.clusterSize(this.nodea));
        this.verifyNodeSeesUpdatedIndex(this.nodea);
        this.verifyNodeSeesUpdatedIndex(this.nodeb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyNodeSeesUpdatedIndex(FullTextSessionBuilder node) {
        FullTextSession fullTextSession = node.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(SimpleEmail.class).get();
            Query query = queryBuilder.keyword().onField("message").matching((Object)"Hibernate Getting Started").createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[0]).setProjection(new String[]{"message"}).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Object[] result = (Object[])list.get(0);
            Assert.assertEquals((Object)"to get started as a real spam expert, search for 'getting an iphone' on Hibernate forums", (Object)result[0]);
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.nodea = new FullTextSessionBuilder();
        this.nodeb = new FullTextSessionBuilder();
        this.prepareCommonConfiguration(this.nodea);
        this.nodea.build();
        this.prepareCommonConfiguration(this.nodeb);
        this.nodeb.build();
        this.waitMembersCount(this.nodea, 2);
    }

    private void waitMembersCount(FullTextSessionBuilder node, int expectedSize) throws InterruptedException {
        int currentSize = 0;
        int loopCounter = 0;
        while (currentSize < expectedSize) {
            Thread.sleep(10L);
            currentSize = this.clusterSize(node);
            if (loopCounter <= 200) continue;
            throw new AssertionFailedError("timeout while waiting for all nodes to join in cluster");
        }
    }

    private int clusterSize(FullTextSessionBuilder node) {
        SearchFactory searchFactory = node.getSearchFactory();
        DirectoryProvider[] directoryProviders = searchFactory.getDirectoryProviders(SimpleEmail.class);
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)directoryProviders[0];
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }

    private void prepareCommonConfiguration(FullTextSessionBuilder cfg) {
        cfg.setProperty("hibernate.search.default.directory_provider", "infinispan");
        cfg.setProperty("hibernate.search.infinispan.configuration_resourcename", "testing-hibernatesearch-infinispan.xml");
        cfg.addAnnotatedClass(SimpleEmail.class);
    }

    @After
    public void tearDown() throws Exception {
        this.nodea.close();
        this.nodeb.close();
    }
}

