/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.infinispan.sharedIndex;

import java.util.HashSet;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.infinispan.ClusterSharedConnectionProvider;
import org.hibernate.search.infinispan.ClusterTestHelper;
import org.hibernate.search.infinispan.impl.InfinispanDirectoryProvider;
import org.hibernate.search.infinispan.sharedIndex.Device;
import org.hibernate.search.infinispan.sharedIndex.Robot;
import org.hibernate.search.infinispan.sharedIndex.Toaster;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SharedIndexTest {
    FullTextSessionBuilder node;
    HashSet<Class<?>> entityTypes;

    @Test
    public void testSingleResultFromDeviceIndex() {
        Assert.assertEquals((long)1L, (long)this.clusterSize(this.node, Toaster.class));
        FullTextSession fullTextSession = this.node.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        Toaster toaster = new Toaster("A1");
        fullTextSession.save((Object)toaster);
        transaction.commit();
        fullTextSession.close();
        this.verifyResult(this.node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyResult(FullTextSessionBuilder node) {
        FullTextSession fullTextSession = node.openFullTextSession();
        try {
            Transaction transaction = fullTextSession.beginTransaction();
            QueryBuilder queryBuilder = fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Toaster.class).get();
            Query query = queryBuilder.keyword().onField("serialNumber").matching((Object)"A1").createQuery();
            List list = fullTextSession.createFullTextQuery(query, new Class[0]).list();
            Assert.assertEquals((long)1L, (long)list.size());
            Device device = (Device)list.get(0);
            Assert.assertEquals((Object)"GE", (Object)device.manufacturer);
            transaction.commit();
        }
        finally {
            fullTextSession.close();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.entityTypes = new HashSet();
        this.entityTypes.add(Device.class);
        this.entityTypes.add(Robot.class);
        this.entityTypes.add(Toaster.class);
        this.node = ClusterTestHelper.createClusterNode(this.entityTypes, true);
        ClusterTestHelper.waitMembersCount(this.node, Toaster.class, 1);
    }

    @After
    public void tearDown() throws Exception {
        if (this.node != null) {
            this.node.close();
        }
    }

    @BeforeClass
    public static void prepareConnectionPool() {
        ClusterSharedConnectionProvider.realStart();
    }

    @AfterClass
    public static void shutdownConnectionPool() {
        ClusterSharedConnectionProvider.realStop();
    }

    protected int clusterSize(FullTextSessionBuilder node, Class<?> entityType) {
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)node.getSearchFactory();
        EntityIndexBinding indexBinding = searchFactory.getIndexBinding(Toaster.class);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBinding.getIndexManagers()[0];
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)indexManager.getDirectoryProvider();
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }
}

