/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.cachestore;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.infinispan.Cache;
import org.infinispan.container.entries.ImmortalCacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoader;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderMetadata;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.cachestore.ContractAdaptorFactory;
import org.infinispan.lucene.cachestore.DirectoryLoaderAdaptor;
import org.infinispan.lucene.cachestore.InternalDirectoryContract;
import org.infinispan.lucene.cachestore.LuceneCacheLoaderConfig;
import org.infinispan.lucene.logging.Log;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.util.logging.LogFactory;

@CacheLoaderMetadata(configurationClass=LuceneCacheLoaderConfig.class)
public class LuceneCacheLoader
implements CacheLoader {
    private static final Log log = (Log)LogFactory.getLog(LuceneCacheLoader.class, Log.class);
    private final ConcurrentHashMap<String, DirectoryLoaderAdaptor> openDirectories = new ConcurrentHashMap();
    private String fileRoot;
    private File rootDirectory;
    private int autoChunkSize;

    public void init(CacheLoaderConfig config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        LuceneCacheLoaderConfig cfg = (LuceneCacheLoaderConfig)config;
        this.fileRoot = cfg.location;
        this.autoChunkSize = cfg.autoChunkSize;
    }

    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        if (key instanceof IndexScopedKey) {
            IndexScopedKey indexKey = (IndexScopedKey)key;
            DirectoryLoaderAdaptor directoryAdaptor = this.getDirectory(indexKey);
            Object value = directoryAdaptor.load(indexKey);
            if (value != null) {
                return new ImmortalCacheEntry(key, value);
            }
            return null;
        }
        log.cacheLoaderIgnoringKey(key);
        return null;
    }

    public boolean containsKey(Object key) throws CacheLoaderException {
        if (key instanceof IndexScopedKey) {
            IndexScopedKey indexKey = (IndexScopedKey)key;
            DirectoryLoaderAdaptor directoryAdaptor = this.getDirectory(indexKey);
            return directoryAdaptor.containsKey(indexKey);
        }
        log.cacheLoaderIgnoringKey(key);
        return false;
    }

    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    public Set<InternalCacheEntry> load(int maxEntries) throws CacheLoaderException {
        this.scanForUnknownDirectories();
        HashSet<InternalCacheEntry> allInternalEntries = new HashSet<InternalCacheEntry>();
        for (DirectoryLoaderAdaptor dir : this.openDirectories.values()) {
            dir.loadAllEntries(allInternalEntries, maxEntries);
        }
        return allInternalEntries;
    }

    public Set<Object> loadAllKeys(Set keysToExclude) throws CacheLoaderException {
        this.scanForUnknownDirectories();
        HashSet<Object> allKeys = new HashSet<Object>();
        for (DirectoryLoaderAdaptor dir : this.openDirectories.values()) {
            dir.loadAllKeys(allKeys, keysToExclude);
        }
        return allKeys;
    }

    private void scanForUnknownDirectories() {
        File[] filesInRoot;
        for (File maybeDirectory : filesInRoot = this.rootDirectory.listFiles()) {
            if (!maybeDirectory.isDirectory()) continue;
            String name = maybeDirectory.getName();
            try {
                this.getDirectory(name);
            }
            catch (CacheLoaderException e) {
                log.couldNotWalkDirectory(name, e);
            }
        }
    }

    public void start() throws CacheLoaderException {
        this.rootDirectory = new File(this.fileRoot);
        if (this.rootDirectory.exists()) {
            if (!this.rootDirectory.isDirectory() || !this.rootDirectory.canRead()) {
                throw log.rootDirectoryIsNotADirectory(this.fileRoot);
            }
        } else {
            boolean mkdirsSuccess = this.rootDirectory.mkdirs();
            if (!mkdirsSuccess) {
                throw log.unableToCreateDirectory(this.fileRoot);
            }
        }
    }

    public void stop() throws CacheLoaderException {
        for (Map.Entry<String, DirectoryLoaderAdaptor> entry : this.openDirectories.entrySet()) {
            DirectoryLoaderAdaptor directory = entry.getValue();
            directory.close();
        }
    }

    public Class<? extends CacheLoaderConfig> getConfigurationClass() {
        return LuceneCacheLoaderConfig.class;
    }

    private DirectoryLoaderAdaptor getDirectory(IndexScopedKey indexKey) throws CacheLoaderException {
        String indexName = indexKey.getIndexName();
        return this.getDirectory(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirectoryLoaderAdaptor getDirectory(String indexName) throws CacheLoaderException {
        DirectoryLoaderAdaptor adapter = this.openDirectories.get(indexName);
        if (adapter == null) {
            ConcurrentHashMap<String, DirectoryLoaderAdaptor> concurrentHashMap = this.openDirectories;
            synchronized (concurrentHashMap) {
                adapter = this.openDirectories.get(indexName);
                if (adapter == null) {
                    File path = new File(this.rootDirectory, indexName);
                    FSDirectory directory = this.openLuceneDirectory(path);
                    InternalDirectoryContract wrapped = ContractAdaptorFactory.wrapNativeDirectory((Directory)directory);
                    adapter = new DirectoryLoaderAdaptor(wrapped, indexName, this.autoChunkSize);
                    this.openDirectories.put(indexName, adapter);
                }
            }
        }
        return adapter;
    }

    private FSDirectory openLuceneDirectory(File path) throws CacheLoaderException {
        try {
            return FSDirectory.open((File)path);
        }
        catch (IOException e) {
            throw log.exceptionInCacheLoader(e);
        }
    }
}

