/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.jgroups;

import java.net.URL;
import java.util.Properties;
import org.hibernate.search.backend.impl.jgroups.ClassloaderMessageListener;
import org.hibernate.search.backend.impl.jgroups.DispatcherMessageSender;
import org.hibernate.search.backend.impl.jgroups.JGroupsMasterMessageListener;
import org.hibernate.search.backend.impl.jgroups.MasterSelectorServiceProvider;
import org.hibernate.search.backend.impl.jgroups.MessageListenerToRequestHandlerAdapter;
import org.hibernate.search.backend.impl.jgroups.MessageSender;
import org.hibernate.search.backend.impl.jgroups.NodeSelectorStrategyHolder;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.MessageListener;
import org.jgroups.UpHandler;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.mux.MuxMessageDispatcher;
import org.jgroups.blocks.mux.Muxer;

public class JGroupsChannelProvider
implements ServiceProvider<MessageSender> {
    private static final Log log = LoggerFactory.make();
    public static final String JGROUPS_PREFIX = "hibernate.search.services.jgroups.";
    public static final String CONFIGURATION_FILE = "hibernate.search.services.jgroups.configurationFile";
    public static final String CLUSTER_NAME = "hibernate.search.services.jgroups.clusterName";
    public static final String CHANNEL_INJECT = "hibernate.search.services.jgroups.providedChannel";
    public static final String CLASSLOADER = "hibernate.search.services.jgroups.classloader";
    public static final String MUX_ID = "hibernate.search.services.jgroups.mux_id";
    private static final String DEFAULT_JGROUPS_CONFIGURATION_FILE = "flush-udp.xml";
    private static final String DEFAULT_CLUSTER_NAME = "Hibernate Search Cluster";
    private ChannelContainer channelContainer;
    private MessageSender sender;
    private ServiceManager serviceManager;

    @Override
    public void start(Properties props, BuildContext context) {
        log.jGroupsStartingChannelProvider();
        this.serviceManager = context.getServiceManager();
        this.channelContainer = JGroupsChannelProvider.buildChannel(props);
        this.channelContainer.start();
        NodeSelectorStrategyHolder masterNodeSelector = (NodeSelectorStrategyHolder)this.serviceManager.requestService(MasterSelectorServiceProvider.class, context);
        JGroupsMasterMessageListener listener = new JGroupsMasterMessageListener(context, masterNodeSelector);
        JChannel channel = this.channelContainer.getChannel();
        UpHandler handler = channel.getUpHandler();
        if (handler instanceof Muxer) {
            Short muxId = (Short)props.get(MUX_ID);
            if (muxId == null) {
                throw log.missingJGroupsMuxId();
            }
            Muxer muxer = (Muxer)handler;
            if (muxer.get(muxId.shortValue()) != null) {
                throw log.jGroupsMuxIdAlreadyTaken(muxId);
            }
            ClassLoader cl = (ClassLoader)props.get(CLASSLOADER);
            Object wrapper = cl != null ? new ClassloaderMessageListener((MessageListener)listener, cl) : listener;
            MessageListenerToRequestHandlerAdapter adapter = new MessageListenerToRequestHandlerAdapter((MessageListener)wrapper);
            MuxMessageDispatcher dispatcher = new MuxMessageDispatcher(muxId.shortValue(), (Channel)channel, (MessageListener)wrapper, (MembershipListener)listener, (RequestHandler)adapter);
            this.sender = new DispatcherMessageSender((MessageDispatcher)dispatcher);
        } else {
            MessageListenerToRequestHandlerAdapter adapter = new MessageListenerToRequestHandlerAdapter((MessageListener)listener);
            MessageDispatcher standardDispatcher = new MessageDispatcher((Channel)channel, (MessageListener)listener, (MembershipListener)listener, (RequestHandler)adapter);
            this.sender = new DispatcherMessageSender(standardDispatcher);
        }
        masterNodeSelector.setLocalAddress(channel.getAddress());
        if (!channel.flushSupported()) {
            log.jGroupsFlushNotPresentInStack();
        }
        if (log.isDebugEnabled()) {
            log.jgroupsFullConfiguration(channel.getProtocolStack().printProtocolSpecAsXML());
        }
    }

    @Override
    public MessageSender getService() {
        return this.sender;
    }

    @Override
    public void stop() {
        this.serviceManager.releaseService(MasterSelectorServiceProvider.class);
        this.serviceManager = null;
        try {
            if (this.sender != null) {
                this.sender.stop();
                this.sender = null;
            }
            if (this.channelContainer != null) {
                this.channelContainer.close();
                this.channelContainer = null;
            }
        }
        catch (Exception toLog) {
            log.jGroupsClosingChannelError(toLog);
        }
    }

    private static ChannelContainer buildChannel(Properties props) {
        String clusterName = ConfigurationParseHelper.getString(props, CLUSTER_NAME, DEFAULT_CLUSTER_NAME);
        if (props != null) {
            Object channelObject = props.get(CHANNEL_INJECT);
            if (channelObject != null) {
                try {
                    return new InjectedChannelContainer((JChannel)channelObject);
                }
                catch (ClassCastException e) {
                    throw log.jGroupsChannelInjectionError(e, channelObject.getClass());
                }
            }
            String cfg = props.getProperty(CONFIGURATION_FILE);
            if (cfg != null) {
                try {
                    log.startingJGroupsChannel(cfg);
                    return new ManagedChannelContainer(new JChannel(ConfigurationParseHelper.locateConfig(cfg)), clusterName);
                }
                catch (Exception e) {
                    throw log.jGroupsChannelCreationUsingFileError(cfg, e);
                }
            }
        }
        log.jGroupsConfigurationNotFoundInProperties(props);
        try {
            URL fileUrl = ConfigurationParseHelper.locateConfig(DEFAULT_JGROUPS_CONFIGURATION_FILE);
            if (fileUrl != null) {
                log.startingJGroupsChannel(fileUrl);
                return new ManagedChannelContainer(new JChannel(fileUrl), clusterName);
            }
            log.jGroupsDefaultConfigurationFileNotFound();
            return new ManagedChannelContainer(new JChannel(), clusterName);
        }
        catch (Exception e) {
            throw log.unableToStartJGroupsChannel(e);
        }
    }

    private static class InjectedChannelContainer
    implements ChannelContainer {
        private final JChannel channel;

        InjectedChannelContainer(JChannel channel) {
            if (channel == null) {
                throw new NullPointerException("channel must not be null");
            }
            this.channel = channel;
        }

        @Override
        public JChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
        }

        @Override
        public void start() {
        }
    }

    private static class ManagedChannelContainer
    implements ChannelContainer {
        private final JChannel channel;
        private final String clusterName;

        ManagedChannelContainer(JChannel channel, String clusterName) {
            if (channel == null) {
                throw new NullPointerException("channel must not be null");
            }
            if (clusterName == null) {
                throw new NullPointerException("clusterName must not be null");
            }
            this.channel = channel;
            this.clusterName = clusterName;
        }

        @Override
        public JChannel getChannel() {
            return this.channel;
        }

        @Override
        public void close() {
            log.jGroupsDisconnectingAndClosingChannel(this.clusterName);
            this.channel.disconnect();
            this.channel.close();
        }

        @Override
        public void start() {
            try {
                this.channel.connect(this.clusterName);
                log.jGroupsConnectedToCluster(this.clusterName, this.channel.getAddress());
            }
            catch (Exception e) {
                throw log.unableConnectingToJGroupsCluster(this.clusterName, e);
            }
        }
    }

    private static interface ChannelContainer {
        public JChannel getChannel();

        public void close();

        public void start();
    }
}

