/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.backend.impl.lucene.AbstractCommitPolicy;
import org.hibernate.search.backend.impl.lucene.IndexWriterHolder;
import org.hibernate.search.batchindexing.impl.Executors;

public final class ScheduledCommitPolicy
extends AbstractCommitPolicy {
    public static final int DEFAULT_DELAY_MS = 1000;
    private final ScheduledExecutorService scheduledExecutorService;
    private final int delay;

    public ScheduledCommitPolicy(IndexWriterHolder indexWriterHolder, String indexName, int delay) {
        super(indexWriterHolder);
        this.delay = delay;
        this.scheduledExecutorService = Executors.newScheduledThreadPool("Commit Scheduler for index " + indexName);
        this.scheduledExecutorService.scheduleWithFixedDelay(new CommitTask(), 1000L, delay, TimeUnit.MILLISECONDS);
    }

    public int getDelay() {
        return this.delay;
    }

    @Override
    public void onChangeSetApplied(boolean someFailureHappened, boolean streaming) {
        if (someFailureHappened) {
            this.indexWriterHolder.forceLockRelease();
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Override
    public void onFlush() {
        this.indexWriterHolder.commitIndexWriter();
    }

    @Override
    public void onClose() {
        this.scheduledExecutorService.shutdown();
    }

    private final class CommitTask
    implements Runnable {
        private CommitTask() {
        }

        @Override
        public void run() {
            if (ScheduledCommitPolicy.this.getIndexWriter() != null) {
                ScheduledCommitPolicy.this.indexWriterHolder.commitIndexWriter();
            }
        }
    }
}

