/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import org.infinispan.Cache;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.spi.DistributedTaskLifecycleService;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.InfinispanCollections;

public class DistributedExecuteCommand<V>
extends BaseRpcCommand
implements VisitableCommand,
CancellableCommand {
    public static final int COMMAND_ID = 19;
    private static final long serialVersionUID = -7828117401763700385L;
    private Cache<Object, Object> cache;
    private Set<Object> keys;
    private Callable<V> callable;
    private UUID uuid;

    public DistributedExecuteCommand(String cacheName) {
        this(cacheName, null, null);
    }

    public DistributedExecuteCommand(String cacheName, Collection<Object> inputKeys, Callable<V> callable) {
        super(cacheName);
        this.keys = inputKeys == null || inputKeys.isEmpty() ? InfinispanCollections.emptySet() : new HashSet<Object>(inputKeys);
        this.callable = callable;
        this.uuid = UUID.randomUUID();
    }

    public DistributedExecuteCommand() {
        this(null, null, null);
    }

    public void init(Cache<Object, Object> cache) {
        this.cache = cache;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitDistributedExecuteCommand(ctx, this);
    }

    @Override
    public boolean ignoreCommandOnStatus(ComponentStatus status) {
        return false;
    }

    @Override
    public boolean shouldInvoke(InvocationContext ctx) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object perform(InvocationContext context) throws Throwable {
        DistributedTaskLifecycleService taskLifecycleService = DistributedTaskLifecycleService.getInstance();
        Callable<V> callable = this.getCallable();
        Object result = null;
        try {
            taskLifecycleService.onPreExecute(callable, this.cache);
            if (callable instanceof DistributedCallable) {
                DistributedCallable dc = (DistributedCallable)callable;
                dc.setEnvironment(this.cache, this.keys);
            }
            result = callable.call();
        }
        finally {
            taskLifecycleService.onPostExecute(callable);
        }
        return result;
    }

    public Callable<V> getCallable() {
        return this.callable;
    }

    public Set<Object> getKeys() {
        return this.keys;
    }

    public boolean hasKeys() {
        return this.keys.isEmpty();
    }

    @Override
    public byte getCommandId() {
        return 19;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.keys, this.callable, this.uuid};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 19) {
            throw new IllegalStateException("Invalid method id");
        }
        int i = 0;
        this.keys = (Set)args[i++];
        this.callable = (Callable)args[i++];
        this.uuid = (UUID)args[i++];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keys == null ? 0 : ((Object)this.keys).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DistributedExecuteCommand)) {
            return false;
        }
        DistributedExecuteCommand other = (DistributedExecuteCommand)obj;
        return !(this.keys == null ? other.keys != null : !((Object)this.keys).equals(other.keys));
    }

    @Override
    public String toString() {
        return "DistributedExecuteCommand [cache=" + this.cache + ", keys=" + this.keys + ", callable=" + this.callable + "]";
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }
}

