/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.metadata.Metadata;
import org.infinispan.util.Util;

public class MetadataTransientMortalCacheValue
extends MetadataMortalCacheValue
implements MetadataAware {
    long lastUsed;

    public MetadataTransientMortalCacheValue(Object v, Metadata metadata, long created, long lastUsed) {
        super(v, metadata, created);
        this.lastUsed = lastUsed;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new MetadataTransientMortalCacheEntry(key, this.value, this.metadata, this.lastUsed, this.created);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public boolean isExpired() {
        return this.isExpired(System.currentTimeMillis());
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientMortalCacheValue> {
        @Override
        public void writeObject(ObjectOutput output, MetadataTransientMortalCacheValue value) throws IOException {
            output.writeObject(value.value);
            output.writeObject(value.metadata);
            UnsignedNumeric.writeUnsignedLong(output, value.created);
            UnsignedNumeric.writeUnsignedLong(output, value.lastUsed);
        }

        @Override
        public MetadataTransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong(input);
            long lastUsed = UnsignedNumeric.readUnsignedLong(input);
            return new MetadataTransientMortalCacheValue(v, metadata, created, lastUsed);
        }

        @Override
        public Integer getId() {
            return 83;
        }

        @Override
        public Set<Class<? extends MetadataTransientMortalCacheValue>> getTypeClasses() {
            return Util.asSet(MetadataTransientMortalCacheValue.class);
        }
    }
}

