/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distribution.ch;

import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.infinispan.distribution.ch.SyncConsistentHashFactory;
import org.infinispan.distribution.topologyaware.TopologyLevel;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.TopologyAwareAddress;

public class TopologyAwareSyncConsistentHashFactory
extends SyncConsistentHashFactory {
    @Override
    protected void populateOwnersFewSegments(SyncConsistentHashFactory.Builder builder, SortedMap<Integer, Address> primarySegments) {
        for (Map.Entry<Integer, Address> e : primarySegments.entrySet()) {
            Integer segment = e.getKey();
            Address primaryOwner = e.getValue();
            builder.getOwners(segment).add(primaryOwner);
        }
        this.populateBackupOwners(builder, TopologyLevel.SITE);
        this.populateBackupOwners(builder, TopologyLevel.RACK);
        this.populateBackupOwners(builder, TopologyLevel.MACHINE);
        this.populateBackupOwners(builder, TopologyLevel.NODE);
    }

    private boolean populateBackupOwners(SyncConsistentHashFactory.Builder builder, TopologyLevel level) {
        boolean modified = false;
        block0: for (Address member : builder.getSortedMembers()) {
            int initSegment = this.normalizedHash(builder.getHashFunction(), member.hashCode()) / builder.getSegmentSize();
            for (int i = 0; i < builder.getNumSegments(); ++i) {
                int segment = (builder.getNumSegments() + initSegment - i) % builder.getNumSegments();
                List<Address> owners = builder.getOwners(segment);
                if (owners.size() >= builder.getActualNumOwners() || !this.locationAlreadyAdded(member, owners, level)) continue;
                owners.add(member);
                modified = true;
                continue block0;
            }
        }
        return modified;
    }

    @Override
    protected void populateOwnersManySegments(SyncConsistentHashFactory.Builder builder, SortedMap<Integer, Address> primarySegments) {
        for (int segment = 0; segment < builder.getNumSegments(); ++segment) {
            this.populateSegmentOwners(builder, primarySegments, segment, TopologyLevel.SITE);
            this.populateSegmentOwners(builder, primarySegments, segment, TopologyLevel.RACK);
            this.populateSegmentOwners(builder, primarySegments, segment, TopologyLevel.MACHINE);
            this.populateSegmentOwners(builder, primarySegments, segment, TopologyLevel.NODE);
        }
    }

    private void populateSegmentOwners(SyncConsistentHashFactory.Builder builder, SortedMap<Integer, Address> primarySegments, int segment, TopologyLevel level) {
        List<Address> owners = builder.getOwners(segment);
        if (owners.size() >= builder.getActualNumOwners()) {
            return;
        }
        for (Address a : primarySegments.tailMap(segment).values()) {
            if (owners.size() >= builder.getActualNumOwners()) {
                return;
            }
            if (this.locationAlreadyAdded(a, owners, level)) continue;
            owners.add(a);
        }
        for (Address a : primarySegments.headMap(segment).values()) {
            if (owners.size() >= builder.getActualNumOwners()) {
                return;
            }
            if (this.locationAlreadyAdded(a, owners, level)) continue;
            owners.add(a);
        }
    }

    private boolean locationAlreadyAdded(Address candidate, List<Address> owners, TopologyLevel level) {
        TopologyAwareAddress topologyAwareCandidate = (TopologyAwareAddress)candidate;
        boolean locationAlreadyAdded = false;
        for (Address owner : owners) {
            TopologyAwareAddress topologyAwareOwner = (TopologyAwareAddress)owner;
            switch (level) {
                case SITE: {
                    locationAlreadyAdded = topologyAwareCandidate.isSameSite(topologyAwareOwner);
                    break;
                }
                case RACK: {
                    locationAlreadyAdded = topologyAwareCandidate.isSameRack(topologyAwareOwner);
                    break;
                }
                case MACHINE: {
                    locationAlreadyAdded = topologyAwareCandidate.isSameMachine(topologyAwareOwner);
                    break;
                }
                case NODE: {
                    locationAlreadyAdded = owner.equals(candidate);
                }
            }
            if (!locationAlreadyAdded) continue;
            break;
        }
        return locationAlreadyAdded;
    }

    public static class Externalizer
    extends AbstractExternalizer<TopologyAwareSyncConsistentHashFactory> {
        @Override
        public void writeObject(ObjectOutput output, TopologyAwareSyncConsistentHashFactory chf) {
        }

        @Override
        public TopologyAwareSyncConsistentHashFactory readObject(ObjectInput unmarshaller) {
            return new TopologyAwareSyncConsistentHashFactory();
        }

        @Override
        public Integer getId() {
            return 95;
        }

        @Override
        public Set<Class<? extends TopologyAwareSyncConsistentHashFactory>> getTypeClasses() {
            return Collections.singleton(TopologyAwareSyncConsistentHashFactory.class);
        }
    }
}

