/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class SerializationHelper {
    private static Log log = LoggerFactory.make();

    private SerializationHelper() {
    }

    public static byte[] toByteArray(Serializable instance) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream stream = new ObjectOutputStream(out);
            stream.writeObject(instance);
            stream.close();
        }
        catch (IOException e) {
            throw log.failToSerializeObject(instance.getClass(), e);
        }
        return out.toByteArray();
    }

    public static <T> T toInstance(byte[] data, Class<T> clazz) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            ClassLoaderAwareObjectInputStream in = new ClassLoaderAwareObjectInputStream(byteIn, clazz.getClassLoader());
            return (T)in.readObject();
        }
        catch (IOException e) {
            throw log.failToDeserializeObject(e);
        }
        catch (ClassNotFoundException e) {
            throw log.failToDeserializeObject(e);
        }
    }

    public static Serializable toSerializable(byte[] data, ClassLoader loader) {
        try {
            ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
            ClassLoaderAwareObjectInputStream in = new ClassLoaderAwareObjectInputStream(byteIn, loader);
            return (Serializable)in.readObject();
        }
        catch (IOException e) {
            throw log.failToDeserializeObject(e);
        }
        catch (ClassNotFoundException e) {
            throw log.failToDeserializeObject(e);
        }
    }

    private static class ClassLoaderAwareObjectInputStream
    extends ObjectInputStream {
        private ClassLoader classLoader;

        public ClassLoaderAwareObjectInputStream(InputStream in, ClassLoader classLoader) throws IOException {
            super(in);
            this.classLoader = classLoader;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            try {
                Class<?> clazz = Class.forName(desc.getName(), false, this.classLoader);
                return clazz;
            }
            catch (ClassNotFoundException ex) {
                return super.resolveClass(desc);
            }
        }
    }
}

