/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.standard;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.ClassicFilter;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;

public final class ClassicAnalyzer
extends StopwordAnalyzerBase {
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;
    public static final CharArraySet STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;

    public ClassicAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public ClassicAnalyzer() {
        this(STOP_WORDS_SET);
    }

    public ClassicAnalyzer(Reader stopwords) throws IOException {
        this(ClassicAnalyzer.loadStopwordSet(stopwords));
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        final ClassicTokenizer src = new ClassicTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenFilter tok = new ClassicFilter((TokenStream)src);
        tok = new LowerCaseFilter((TokenStream)tok);
        tok = new StopFilter((TokenStream)tok, this.stopwords);
        return new Analyzer.TokenStreamComponents(src, (TokenStream)tok){

            protected void setReader(Reader reader) throws IOException {
                src.setMaxTokenLength(ClassicAnalyzer.this.maxTokenLength);
                super.setReader(reader);
            }
        };
    }
}

