/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.impl;

import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.backend.LuceneWork;

public class BackendRequest<T extends JestResult> {
    private Action<T> action;
    private Set<Integer> ignoredErrorStatuses;
    private LuceneWork luceneWork;

    public BackendRequest(Action<T> action, LuceneWork luceneWork, int ... ignoredErrorStatuses) {
        this.action = action;
        this.luceneWork = luceneWork;
        this.ignoredErrorStatuses = BackendRequest.asSet(ignoredErrorStatuses);
    }

    private static Set<Integer> asSet(int ... ignoredErrorStatuses) {
        if (ignoredErrorStatuses == null || ignoredErrorStatuses.length == 0) {
            return Collections.emptySet();
        }
        if (ignoredErrorStatuses.length == 1) {
            return Collections.singleton(ignoredErrorStatuses[0]);
        }
        HashSet<Integer> ignored = new HashSet<Integer>();
        for (int ignoredErrorStatus : ignoredErrorStatuses) {
            ignored.add(ignoredErrorStatus);
        }
        return Collections.unmodifiableSet(ignored);
    }

    public LuceneWork getLuceneWork() {
        return this.luceneWork;
    }

    public Action<T> getAction() {
        return this.action;
    }

    public Set<Integer> getIgnoredErrorStatuses() {
        return this.ignoredErrorStatuses;
    }

    public String toString() {
        return "BackendRequest [action=" + this.action + ", ignoredErrorStatuses=" + this.ignoredErrorStatuses + "]";
    }
}

