/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.engine.BoostStrategy;
import org.hibernate.search.engine.impl.DefaultBoostStrategy;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.SortableFieldMetadata;
import org.hibernate.search.util.impl.ReflectionHelper;

public class PropertyMetadata {
    private final XProperty propertyAccessor;
    private final Map<String, DocumentFieldMetadata> documentFieldMetadataMap;
    private final Set<DocumentFieldMetadata> documentFieldMetadataList;
    private final Set<SortableFieldMetadata> sortableFieldMetadata;
    private final BoostStrategy dynamicBoostStrategy;
    private final String propertyAccessorName;
    private final Map<String, BridgeDefinedField> bridgeDefinedFields;

    private PropertyMetadata(Builder builder) {
        this.propertyAccessor = builder.propertyAccessor;
        this.documentFieldMetadataList = Collections.unmodifiableSet(builder.fieldMetadataSet);
        this.documentFieldMetadataMap = this.createDocumentFieldMetadataMap(builder.fieldMetadataSet);
        this.sortableFieldMetadata = Collections.unmodifiableSet(builder.sortableFieldMetadata);
        this.bridgeDefinedFields = Collections.unmodifiableMap(builder.bridgeDefinedFields);
        this.propertyAccessorName = this.propertyAccessor == null ? null : this.propertyAccessor.getName();
        this.dynamicBoostStrategy = builder.dynamicBoostStrategy != null ? builder.dynamicBoostStrategy : DefaultBoostStrategy.INSTANCE;
    }

    private Map<String, DocumentFieldMetadata> createDocumentFieldMetadataMap(Set<DocumentFieldMetadata> fieldMetadataSet) {
        HashMap<String, DocumentFieldMetadata> tmpMap = new HashMap<String, DocumentFieldMetadata>();
        for (DocumentFieldMetadata documentFieldMetadata : fieldMetadataSet) {
            tmpMap.put(documentFieldMetadata.getName(), documentFieldMetadata);
        }
        return Collections.unmodifiableMap(tmpMap);
    }

    public XProperty getPropertyAccessor() {
        return this.propertyAccessor;
    }

    public String getPropertyAccessorName() {
        return this.propertyAccessorName;
    }

    @Deprecated
    public List<DocumentFieldMetadata> getFieldMetadata() {
        return new ArrayList<DocumentFieldMetadata>(this.documentFieldMetadataList);
    }

    public Set<DocumentFieldMetadata> getFieldMetadataSet() {
        return this.documentFieldMetadataList;
    }

    public DocumentFieldMetadata getFieldMetadata(String fieldName) {
        return this.documentFieldMetadataMap.get(fieldName);
    }

    public Set<SortableFieldMetadata> getSortableFieldMetadata() {
        return this.sortableFieldMetadata;
    }

    public Map<String, BridgeDefinedField> getBridgeDefinedFields() {
        return this.bridgeDefinedFields;
    }

    public BoostStrategy getDynamicBoostStrategy() {
        return this.dynamicBoostStrategy;
    }

    public String toString() {
        return "PropertyMetadata{propertyAccessor=" + this.propertyAccessor + ", fieldMetadata=" + this.documentFieldMetadataList + ", dynamicBoostStrategy=" + this.dynamicBoostStrategy + '}';
    }

    public static class Builder {
        private final XProperty propertyAccessor;
        private final Set<DocumentFieldMetadata> fieldMetadataSet;
        private final Set<SortableFieldMetadata> sortableFieldMetadata;
        private final Map<String, BridgeDefinedField> bridgeDefinedFields;
        private BoostStrategy dynamicBoostStrategy;

        public Builder(XProperty propertyAccessor) {
            if (propertyAccessor != null) {
                ReflectionHelper.setAccessible((XMember)propertyAccessor);
            }
            this.propertyAccessor = propertyAccessor;
            this.fieldMetadataSet = new HashSet<DocumentFieldMetadata>();
            this.sortableFieldMetadata = new HashSet<SortableFieldMetadata>();
            this.bridgeDefinedFields = new HashMap<String, BridgeDefinedField>();
        }

        public Builder dynamicBoostStrategy(BoostStrategy boostStrategy) {
            this.dynamicBoostStrategy = boostStrategy;
            return this;
        }

        public Builder addDocumentField(DocumentFieldMetadata documentFieldMetadata) {
            this.fieldMetadataSet.add(documentFieldMetadata);
            return this;
        }

        public Builder addSortableField(SortableFieldMetadata sortableField) {
            this.sortableFieldMetadata.add(sortableField);
            return this;
        }

        public Builder addBridgeDefinedField(BridgeDefinedField bridgeDefinedField) {
            this.bridgeDefinedFields.put(bridgeDefinedField.getName(), bridgeDefinedField);
            return this;
        }

        public XProperty getPropertyAccessor() {
            return this.propertyAccessor;
        }

        public Set<DocumentFieldMetadata> getFieldMetadata() {
            return this.fieldMetadataSet;
        }

        public PropertyMetadata build() {
            return new PropertyMetadata(this);
        }
    }
}

