/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.analyzer.impl.AnalyzerReference;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class ScopedLuceneAnalyzer
extends AnalyzerWrapper
implements ScopedAnalyzer {
    private static final Log log = LoggerFactory.make();
    private Analyzer globalAnalyzer;
    private final Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

    public ScopedLuceneAnalyzer(Analyzer globalAnalyzer) {
        this(globalAnalyzer, Collections.emptyMap());
    }

    public ScopedLuceneAnalyzer(AnalyzerReference globalAnalyzerReference) {
        this(ScopedLuceneAnalyzer.getLuceneAnalyzer(globalAnalyzerReference), Collections.emptyMap());
    }

    private ScopedLuceneAnalyzer(Analyzer globalAnalyzer, Map<String, Analyzer> scopedAnalyzers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzer = globalAnalyzer;
        for (Map.Entry<String, Analyzer> entry : scopedAnalyzers.entrySet()) {
            this.addScopedAnalyzer(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
        this.globalAnalyzer = ScopedLuceneAnalyzer.getLuceneAnalyzer(globalAnalyzerReference);
    }

    public void addScopedAnalyzer(String scope, Analyzer scopedAnalyzer) {
        this.scopedAnalyzers.put(scope, scopedAnalyzer);
    }

    @Override
    public void addScopedAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
        this.scopedAnalyzers.put(scope, ScopedLuceneAnalyzer.getLuceneAnalyzer(analyzerReference));
    }

    @Override
    public void addScopedPassThroughAnalyzerReference(String scope) {
        this.scopedAnalyzers.put(scope, LuceneAnalyzerReference.PASS_THROUGH.getAnalyzer());
    }

    public boolean isCompositeOfSameInstances(ScopedLuceneAnalyzer other) {
        if (this.globalAnalyzer != other.globalAnalyzer) {
            return false;
        }
        if (this.scopedAnalyzers.size() != other.scopedAnalyzers.size()) {
            return false;
        }
        for (String fieldname : this.scopedAnalyzers.keySet()) {
            if (this.scopedAnalyzers.get(fieldname) == other.scopedAnalyzers.get(fieldname)) continue;
            return false;
        }
        return true;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        Analyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            return this.globalAnalyzer;
        }
        return analyzer;
    }

    @Override
    public ScopedLuceneAnalyzer clone() {
        ScopedLuceneAnalyzer clone = new ScopedLuceneAnalyzer(this.globalAnalyzer, this.scopedAnalyzers);
        return clone;
    }

    private static Analyzer getLuceneAnalyzer(AnalyzerReference analyzerReference) {
        if (!(analyzerReference instanceof LuceneAnalyzerReference)) {
            throw log.analyzerReferenceIsNotLucene(analyzerReference);
        }
        return ((LuceneAnalyzerReference)analyzerReference).getAnalyzer();
    }
}

