/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.searchbox.core.DocumentResult;
import io.searchbox.core.Explain;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.sort.Sort;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.elasticsearch.client.impl.DistanceSort;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.filter.ElasticsearchFilter;
import org.hibernate.search.elasticsearch.impl.DocumentIdHelper;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.FieldHelper;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.impl.ToElasticsearch;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.engine.impl.FilterDef;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.BridgeDefinedField;
import org.hibernate.search.engine.metadata.impl.DocumentFieldMetadata;
import org.hibernate.search.engine.metadata.impl.PropertyMetadata;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.filter.impl.FullTextFilterImpl;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.query.dsl.impl.DiscreteFacetRequest;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.dsl.impl.RangeFacetRequest;
import org.hibernate.search.query.engine.impl.AbstractHSQuery;
import org.hibernate.search.query.engine.impl.EntityInfoImpl;
import org.hibernate.search.query.engine.impl.FacetComparators;
import org.hibernate.search.query.engine.impl.FacetManagerImpl;
import org.hibernate.search.query.engine.impl.TimeoutManagerImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetSortOrder;
import org.hibernate.search.query.facet.FacetingRequest;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchHSQueryImpl
extends AbstractHSQuery {
    private static final JsonParser JSON_PARSER = new JsonParser();
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final Pattern DOT = Pattern.compile("\\.");
    private static final String SPATIAL_DISTANCE_FIELD = "_distance";
    private static final int MAX_RESULT_WINDOW_SIZE = 10000;
    private static final Set<String> SUPPORTED_PROJECTION_CONSTANTS = Collections.unmodifiableSet(CollectionHelper.asSet((Object[])new String[]{"__HSearch_id", "_hibernate_class", "__HSearch_Score", "__HSearch_Source", "_HSearch_SpatialDistance", "__HSearch_This", "__HSearch_Took", "__HSearch_TimedOut"}));
    private final JsonObject jsonQuery;
    private Integer resultSize;
    private IndexSearcher searcher;
    private SearchResult searchResult;
    private int sortByDistanceIndex = -1;
    private transient FacetManagerImpl facetManager;

    public ElasticsearchHSQueryImpl(JsonObject jsonQuery, ExtendedSearchIntegrator extendedIntegrator) {
        super(extendedIntegrator);
        this.jsonQuery = jsonQuery;
    }

    public HSQuery luceneQuery(Query query) {
        throw LOG.hsQueryLuceneQueryUnsupported();
    }

    public FacetManagerImpl getFacetManager() {
        if (this.facetManager == null) {
            this.facetManager = new FacetManagerImpl((AbstractHSQuery)this);
        }
        return this.facetManager;
    }

    public Query getLuceneQuery() {
        throw LOG.hsQueryLuceneQueryUnsupported();
    }

    public DocumentExtractor queryDocumentExtractor() {
        return new ElasticsearchDocumentExtractor();
    }

    SearchResult getSearchResult() {
        if (this.searchResult == null) {
            this.execute();
        }
        return this.searchResult;
    }

    public int queryResultSize() {
        if (this.searchResult == null) {
            this.execute();
        }
        return this.resultSize;
    }

    public Explanation explain(int documentId) {
        if (this.searchResult == null) {
            this.execute();
        }
        JsonObject hit = this.searchResult.getJsonObject().get("hits").getAsJsonObject().get("hits").getAsJsonArray().get(documentId).getAsJsonObject();
        try (ServiceReference client = this.getExtendedSearchIntegrator().getServiceManager().requestReference(JestClient.class);){
            Explain request = new Explain.Builder(hit.get("_index").getAsString(), hit.get("_type").getAsString(), hit.get("_id").getAsString(), (Object)this.searcher.executedQuery).build();
            DocumentResult response = (DocumentResult)((JestClient)client.get()).executeRequest(request, new int[0]);
            JsonObject explanation = response.getJsonObject().get("explanation").getAsJsonObject();
            Explanation explanation2 = this.convertExplanation(explanation);
            return explanation2;
        }
    }

    private Explanation convertExplanation(JsonObject explanation) {
        List details;
        float value = explanation.get("value").getAsFloat();
        String description = explanation.get("description").getAsString();
        JsonElement explanationDetails = explanation.get("details");
        if (explanationDetails != null) {
            details = new ArrayList(explanationDetails.getAsJsonArray().size());
            for (JsonElement detail : explanationDetails.getAsJsonArray()) {
                details.add(this.convertExplanation(detail.getAsJsonObject()));
            }
        } else {
            details = Collections.emptyList();
        }
        return Explanation.match((float)value, (String)description, details);
    }

    protected void clearCachedResults() {
        this.searchResult = null;
        this.resultSize = null;
    }

    protected TimeoutManagerImpl buildTimeoutManager() {
        return new TimeoutManagerImpl((Object)this.jsonQuery, this.timeoutExceptionFactory, this.extendedIntegrator.getTimingSource());
    }

    public List<EntityInfo> queryEntityInfos() {
        if (this.searchResult == null) {
            this.execute();
        }
        ArrayList<EntityInfo> results = new ArrayList<EntityInfo>(this.searchResult.getTotal());
        JsonObject searchResultJsonObject = this.searchResult.getJsonObject();
        JsonArray hits = searchResultJsonObject.get("hits").getAsJsonObject().get("hits").getAsJsonArray();
        for (JsonElement hit : hits) {
            EntityInfo entityInfo = this.searcher.convertQueryHit(searchResultJsonObject, hit.getAsJsonObject());
            if (entityInfo == null) continue;
            results.add(entityInfo);
        }
        return results;
    }

    protected Set<String> getSupportedProjectionConstants() {
        return SUPPORTED_PROJECTION_CONSTANTS;
    }

    private void execute() {
        this.searcher = new IndexSearcher();
        this.searchResult = this.searcher.runSearch();
        this.resultSize = this.searchResult.getTotal();
    }

    protected void extractFacetResults() {
        SearchResult searchResult = this.getSearchResult();
        JsonElement aggregationsElement = searchResult.getJsonObject().get("aggregations");
        if (aggregationsElement == null) {
            return;
        }
        JsonObject aggregations = aggregationsElement.getAsJsonObject();
        HashMap<String, List<Facet>> results = new HashMap<String, List<Facet>>();
        for (FacetingRequest facetRequest : this.getFacetManager().getFacetRequests().values()) {
            List<Facet> facets;
            if (facetRequest instanceof DiscreteFacetRequest) {
                facets = this.updateStringFacets(aggregations, (DiscreteFacetRequest)facetRequest);
            } else {
                facets = this.updateRangeFacets(aggregations, (RangeFacetRequest)facetRequest);
                if (!FacetSortOrder.RANGE_DEFINITION_ORDER.equals((Object)facetRequest.getSort())) {
                    Collections.sort(facets, FacetComparators.get((FacetSortOrder)facetRequest.getSort()));
                }
            }
            results.put(facetRequest.getFacetingName(), facets);
        }
        this.getFacetManager().setFacetResults(results);
    }

    private List<Facet> updateRangeFacets(JsonObject aggregations, RangeFacetRequest<?> facetRequest) {
        if (!(ReflectionHelper.isIntegerType((Class)facetRequest.getFacetValueType()) || Date.class.isAssignableFrom(facetRequest.getFacetValueType()) || ReflectionHelper.isFloatingPointType((Class)facetRequest.getFacetValueType()))) {
            throw LOG.unsupportedFacetRangeParameter(facetRequest.getFacetValueType().getName());
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (FacetRange facetRange : facetRequest.getFacetRangeList()) {
            int docCount;
            JsonElement aggregation = aggregations.get(facetRequest.getFacetingName() + "-" + facetRange.getIdentifier());
            if (aggregation == null || (docCount = aggregation.getAsJsonObject().get("doc_count").getAsInt()) == 0 && !facetRequest.hasZeroCountsIncluded()) continue;
            facets.add(facetRequest.createFacet(facetRange.getRangeString(), docCount));
        }
        return facets;
    }

    private List<Facet> updateStringFacets(JsonObject aggregations, DiscreteFacetRequest facetRequest) {
        JsonElement aggregation = aggregations.get(facetRequest.getFacetingName());
        if (aggregation == null) {
            return Collections.emptyList();
        }
        if (this.isNested(facetRequest)) {
            aggregation = aggregation.getAsJsonObject().get(facetRequest.getFacetingName());
        }
        if (aggregation == null) {
            return Collections.emptyList();
        }
        ArrayList<Facet> facets = new ArrayList<Facet>();
        for (JsonElement bucket : aggregation.getAsJsonObject().get("buckets").getAsJsonArray()) {
            facets.add(facetRequest.createFacet(bucket.getAsJsonObject().get("key").getAsString(), bucket.getAsJsonObject().get("doc_count").getAsInt()));
        }
        return facets;
    }

    private JsonObject buildFullTextFilter(FullTextFilterImpl fullTextFilter) {
        FilterDef def = this.extendedIntegrator.getFilterDefinition(fullTextFilter.getName());
        if (this.isPreQueryFilterOnly(def)) {
            return null;
        }
        Object filterOrFactory = this.createFilterInstance(fullTextFilter, def);
        return this.createFullTextFilter(def, filterOrFactory);
    }

    protected JsonObject createFullTextFilter(FilterDef def, Object filterOrFactory) {
        JsonObject jsonFilter;
        if (def.getFactoryMethod() != null) {
            try {
                Object candidateFilter = def.getFactoryMethod().invoke(filterOrFactory, new Object[0]);
                if (candidateFilter instanceof Filter) {
                    jsonFilter = ToElasticsearch.fromLuceneFilter((Filter)candidateFilter);
                }
                if (candidateFilter instanceof ElasticsearchFilter) {
                    jsonFilter = JSON_PARSER.parse(((ElasticsearchFilter)candidateFilter).getJsonFilter()).getAsJsonObject();
                }
                throw LOG.filterFactoryMethodReturnsUnsupportedType(def.getImpl().getName(), def.getFactoryMethod().getName());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw LOG.filterFactoryMethodInaccessible(def.getImpl().getName(), def.getFactoryMethod().getName(), e);
            }
        } else if (filterOrFactory instanceof Filter) {
            jsonFilter = ToElasticsearch.fromLuceneFilter((Filter)filterOrFactory);
        } else if (filterOrFactory instanceof ElasticsearchFilter) {
            jsonFilter = JSON_PARSER.parse(((ElasticsearchFilter)filterOrFactory).getJsonFilter()).getAsJsonObject();
        } else {
            throw LOG.filterHasUnsupportedType(filterOrFactory == null ? null : filterOrFactory.getClass().getName());
        }
        return jsonFilter;
    }

    private boolean isNested(DiscreteFacetRequest facetRequest) {
        return false;
    }

    private boolean isPartOfProjectedFields(String projectionName) {
        if (this.projectedFields == null) {
            return false;
        }
        for (String projectedField : this.projectedFields) {
            if (!projectionName.equals(projectedField)) continue;
            return true;
        }
        return false;
    }

    private class ElasticsearchDocumentExtractor
    implements DocumentExtractor {
        private final IndexSearcher searcher;
        private List<EntityInfo> results;

        private ElasticsearchDocumentExtractor() {
            this.searcher = new IndexSearcher();
        }

        public EntityInfo extract(int index) throws IOException {
            if (this.results == null) {
                this.runSearch();
            }
            return this.results.get(index);
        }

        public int getFirstIndex() {
            return 0;
        }

        public int getMaxIndex() {
            if (this.results == null) {
                this.runSearch();
            }
            return this.results.size() - 1;
        }

        public void close() {
        }

        public TopDocs getTopDocs() {
            throw LOG.documentExtractorTopDocsUnsupported();
        }

        private void runSearch() {
            SearchResult searchResult = this.searcher.runSearch();
            JsonObject searchResultJsonObject = searchResult.getJsonObject();
            JsonArray hits = searchResultJsonObject.get("hits").getAsJsonObject().get("hits").getAsJsonArray();
            this.results = new ArrayList<EntityInfo>(searchResult.getTotal());
            for (JsonElement hit : hits) {
                EntityInfo converted = this.searcher.convertQueryHit(searchResultJsonObject, hit.getAsJsonObject());
                if (converted == null) continue;
                this.results.add(converted);
            }
        }
    }

    private class IndexSearcher {
        private final Search search;
        private final Map<String, Class<?>> entityTypesByName = new HashMap();
        private final String executedQuery;

        private IndexSearcher() {
            String idFieldName = null;
            JsonArray typeFilters = new JsonArray();
            HashSet<String> indexNames = new HashSet<String>();
            Iterable<Class<?>> queriedEntityTypes = this.getQueriedEntityTypes();
            for (Class<?> queriedEntityType : queriedEntityTypes) {
                IndexManager[] indexManagers;
                this.entityTypesByName.put(queriedEntityType.getName(), queriedEntityType);
                EntityIndexBinding binding = ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBinding(queriedEntityType);
                IndexManager[] indexManagerArray = indexManagers = binding.getIndexManagers();
                int n = indexManagerArray.length;
                for (int i = 0; i < n; ++i) {
                    IndexManager indexManager = indexManagerArray[i];
                    if (!(indexManager instanceof ElasticsearchIndexManager)) {
                        throw LOG.cannotRunEsQueryTargetingEntityIndexedWithNonEsIndexManager(queriedEntityType, ElasticsearchHSQueryImpl.this.jsonQuery.toString());
                    }
                    idFieldName = binding.getDocumentBuilder().getIdentifierName();
                    ElasticsearchIndexManager esIndexManager = (ElasticsearchIndexManager)indexManager;
                    indexNames.add(esIndexManager.getActualIndexName());
                }
                typeFilters.add((JsonElement)this.getEntityTypeFilter(queriedEntityType));
            }
            JsonObject effectiveFilter = this.getEffectiveFilter(typeFilters);
            JsonBuilder.Object completeQuery = JsonBuilder.object();
            completeQuery.add("query", JsonBuilder.object().add("filtered", JsonBuilder.object(ElasticsearchHSQueryImpl.this.jsonQuery).add("filter", (JsonElement)effectiveFilter)));
            if (!ElasticsearchHSQueryImpl.this.getFacetManager().getFacetRequests().isEmpty()) {
                JsonBuilder.Object facets = JsonBuilder.object();
                for (Map.Entry facetRequestEntry : ElasticsearchHSQueryImpl.this.getFacetManager().getFacetRequests().entrySet()) {
                    ToElasticsearch.addFacetingRequest(facets, (FacetingRequest)facetRequestEntry.getValue());
                }
                completeQuery.add("aggregations", facets);
            }
            ElasticsearchHSQueryImpl.this.sortByDistanceIndex = this.getSortByDistanceIndex();
            this.addScriptFields(completeQuery);
            this.executedQuery = completeQuery.build().toString();
            Search.Builder search = new Search.Builder(this.executedQuery);
            search.addIndex(indexNames);
            search.setParameter("from", (Object)ElasticsearchHSQueryImpl.this.firstResult);
            search.setParameter("size", (Object)(ElasticsearchHSQueryImpl.this.maxResults != null ? ElasticsearchHSQueryImpl.this.maxResults : 10000 - ElasticsearchHSQueryImpl.this.firstResult));
            if (ElasticsearchHSQueryImpl.this.sort != null) {
                ElasticsearchHSQueryImpl.this.validateSortFields(ElasticsearchHSQueryImpl.this.extendedIntegrator, queriedEntityTypes);
                for (SortField sortField : ElasticsearchHSQueryImpl.this.sort.getSort()) {
                    search.addSort(this.getSort(sortField, idFieldName));
                }
            }
            this.search = search.build();
        }

        private JsonObject getEffectiveFilter(JsonArray typeFilters) {
            JsonArray filters = new JsonArray();
            JsonObject tenantFilter = this.getTenantIdFilter();
            if (tenantFilter != null) {
                filters.add((JsonElement)tenantFilter);
            }
            filters.add((JsonElement)ToElasticsearch.condition("should", typeFilters));
            for (Query query : ElasticsearchHSQueryImpl.this.getFacetManager().getFacetFilters().getFilterQueries()) {
                filters.add((JsonElement)ToElasticsearch.fromLuceneQuery(query));
            }
            if (ElasticsearchHSQueryImpl.this.userFilter != null) {
                filters.add((JsonElement)ToElasticsearch.fromLuceneFilter(ElasticsearchHSQueryImpl.this.userFilter));
            }
            if (!ElasticsearchHSQueryImpl.this.filterDefinitions.isEmpty()) {
                for (FullTextFilterImpl fullTextFilter : ElasticsearchHSQueryImpl.this.filterDefinitions.values()) {
                    JsonObject filter = ElasticsearchHSQueryImpl.this.buildFullTextFilter(fullTextFilter);
                    if (filter == null) continue;
                    filters.add((JsonElement)filter);
                }
            }
            return ToElasticsearch.condition("must", filters);
        }

        private JsonObject getEntityTypeFilter(Class<?> queriedEntityType) {
            JsonObject value = new JsonObject();
            value.addProperty("value", queriedEntityType.getName());
            JsonObject type = new JsonObject();
            type.add("type", (JsonElement)value);
            return type;
        }

        private JsonObject getTenantIdFilter() {
            if (ElasticsearchHSQueryImpl.this.tenantId == null) {
                return null;
            }
            JsonObject value = new JsonObject();
            value.addProperty("__HSearch_TenantId", ElasticsearchHSQueryImpl.this.tenantId);
            JsonObject tenantFilter = new JsonObject();
            tenantFilter.add("term", (JsonElement)value);
            return tenantFilter;
        }

        private Iterable<Class<?>> getQueriedEntityTypes() {
            if (ElasticsearchHSQueryImpl.this.indexedTargetedEntities == null || ElasticsearchHSQueryImpl.this.indexedTargetedEntities.isEmpty()) {
                return ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBindings().keySet();
            }
            return ElasticsearchHSQueryImpl.this.indexedTargetedEntities;
        }

        private Sort getSort(SortField sortField, String idFieldName) {
            String sortFieldName;
            block6: {
                block5: {
                    if (sortField instanceof DistanceSortField) {
                        DistanceSortField distanceSortField = (DistanceSortField)sortField;
                        return new DistanceSort(distanceSortField.getField(), distanceSortField.getCenter(), distanceSortField.getReverse() ? Sort.Sorting.DESC : Sort.Sorting.ASC);
                    }
                    if (sortField.getField() != null) break block5;
                    switch (sortField.getType()) {
                        case DOC: {
                            sortFieldName = "_uid";
                            break block6;
                        }
                        case SCORE: {
                            sortFieldName = "_score";
                            break block6;
                        }
                        default: {
                            throw LOG.cannotUseThisSortTypeWithNullSortFieldName(sortField.getType());
                        }
                    }
                }
                sortFieldName = sortField.getField().equals(idFieldName) ? "_uid" : sortField.getField();
            }
            return new Sort(sortFieldName, sortField.getReverse() ? Sort.Sorting.DESC : Sort.Sorting.ASC);
        }

        private int getSortByDistanceIndex() {
            int i = 0;
            if (ElasticsearchHSQueryImpl.this.sort != null) {
                for (SortField sortField : ElasticsearchHSQueryImpl.this.sort.getSort()) {
                    if (sortField instanceof DistanceSortField) {
                        return i;
                    }
                    ++i;
                }
            }
            return -1;
        }

        private boolean isSortedByDistance() {
            return ElasticsearchHSQueryImpl.this.sortByDistanceIndex >= 0;
        }

        private void addScriptFields(JsonBuilder.Object query) {
            if (ElasticsearchHSQueryImpl.this.isPartOfProjectedFields("_HSearch_SpatialDistance") && !this.isSortedByDistance()) {
                query.add("script_fields", JsonBuilder.object().add(ElasticsearchHSQueryImpl.SPATIAL_DISTANCE_FIELD, JsonBuilder.object().add("params", JsonBuilder.object().addProperty("lat", ElasticsearchHSQueryImpl.this.spatialSearchCenter.getLatitude()).addProperty("lon", ElasticsearchHSQueryImpl.this.spatialSearchCenter.getLongitude())).addProperty("script", "doc['" + ElasticsearchHSQueryImpl.this.spatialFieldName + "'].arcDistanceInKm(lat,lon)")));
                query.add("fields", JsonBuilder.array().add((JsonElement)new JsonPrimitive("_source")));
            }
        }

        SearchResult runSearch() {
            try (ServiceReference client = ElasticsearchHSQueryImpl.this.getExtendedSearchIntegrator().getServiceManager().requestReference(JestClient.class);){
                SearchResult searchResult = (SearchResult)((JestClient)client.get()).executeRequest(this.search, new int[0]);
                return searchResult;
            }
        }

        EntityInfo convertQueryHit(JsonObject searchResult, JsonObject hit) {
            String type = hit.get("_type").getAsString();
            Class<?> clazz = this.entityTypesByName.get(type);
            if (clazz == null) {
                LOG.warnf("Found unknown type in Elasticsearch index: " + type, new Object[0]);
                return null;
            }
            EntityIndexBinding binding = ElasticsearchHSQueryImpl.this.extendedIntegrator.getIndexBinding(clazz);
            Object id = this.getId(hit, binding);
            Object[] projections = null;
            if (ElasticsearchHSQueryImpl.this.projectedFields != null) {
                projections = new Object[ElasticsearchHSQueryImpl.this.projectedFields.length];
                block20: for (int i = 0; i < projections.length; ++i) {
                    String field = ElasticsearchHSQueryImpl.this.projectedFields[i];
                    if (field == null) continue;
                    switch (field) {
                        case "__HSearch_Source": {
                            projections[i] = hit.getAsJsonObject().get("_source").toString();
                            continue block20;
                        }
                        case "__HSearch_id": {
                            projections[i] = id;
                            continue block20;
                        }
                        case "_hibernate_class": {
                            projections[i] = clazz;
                            continue block20;
                        }
                        case "__HSearch_Score": {
                            projections[i] = Float.valueOf(hit.getAsJsonObject().get("_score").getAsFloat());
                            continue block20;
                        }
                        case "_HSearch_SpatialDistance": {
                            if (this.isSortedByDistance()) {
                                projections[i] = hit.getAsJsonObject().get("sort").getAsJsonArray().get(ElasticsearchHSQueryImpl.this.sortByDistanceIndex).getAsDouble();
                                continue block20;
                            }
                            projections[i] = hit.getAsJsonObject().get("fields").getAsJsonObject().get(ElasticsearchHSQueryImpl.SPATIAL_DISTANCE_FIELD).getAsDouble();
                            continue block20;
                        }
                        case "__HSearch_Took": {
                            projections[i] = searchResult.get("took").getAsInt();
                            continue block20;
                        }
                        case "__HSearch_TimedOut": {
                            projections[i] = searchResult.get("timed_out").getAsBoolean();
                            continue block20;
                        }
                        case "__HSearch_This": {
                            projections[i] = EntityInfo.ENTITY_PLACEHOLDER;
                            continue block20;
                        }
                        default: {
                            projections[i] = this.getFieldValue(binding, hit, field);
                        }
                    }
                }
            }
            return new EntityInfoImpl(clazz, binding.getDocumentBuilder().getIdentifierName(), (Serializable)id, projections);
        }

        private Object getId(JsonObject hit, EntityIndexBinding binding) {
            Document tmp = new Document();
            tmp.add((IndexableField)new StringField("id", DocumentIdHelper.getEntityId(hit.get("_id").getAsString()), Field.Store.NO));
            this.addIdBridgeDefinedFields(hit, binding, tmp);
            return binding.getDocumentBuilder().getIdBridge().get("id", tmp);
        }

        private void addIdBridgeDefinedFields(JsonObject hit, EntityIndexBinding binding, Document tmp) {
            HashSet allBridgeDefinedFields = new HashSet();
            allBridgeDefinedFields.addAll(binding.getDocumentBuilder().getMetadata().getIdPropertyMetadata().getBridgeDefinedFields().values());
            for (BridgeDefinedField bridgeDefinedField : allBridgeDefinedFields) {
                Object fieldValue = this.getFieldValue(binding, hit, bridgeDefinedField.getName());
                tmp.add((IndexableField)new StringField(bridgeDefinedField.getName(), String.valueOf(fieldValue), Field.Store.NO));
            }
        }

        private Object getFieldValue(EntityIndexBinding binding, JsonObject hit, String projectedField) {
            DocumentFieldMetadata field = FieldHelper.getFieldMetadata(binding, projectedField);
            if (field == null && !this.isBridgeDefinedField(binding, projectedField)) {
                throw LOG.unknownFieldForProjection(binding.getDocumentBuilder().getMetadata().getType().getName(), projectedField);
            }
            JsonElement value = field != null && field.isId() ? hit.get("_id") : this.getFieldValue(hit.get("_source").getAsJsonObject(), projectedField);
            if (value == null || value.isJsonNull()) {
                return null;
            }
            if (field != null) {
                return this.convertFieldValue(binding, field, value);
            }
            return this.convertPrimitiveValue(value);
        }

        private boolean isBridgeDefinedField(EntityIndexBinding binding, String projectedField) {
            BridgeDefinedField bridgeDefinedField = (BridgeDefinedField)binding.getDocumentBuilder().getMetadata().getIdPropertyMetadata().getBridgeDefinedFields().get(projectedField);
            if (bridgeDefinedField != null) {
                return true;
            }
            Set allPropertyMetadata = binding.getDocumentBuilder().getMetadata().getAllPropertyMetadata();
            for (PropertyMetadata propertyMetadata : allPropertyMetadata) {
                bridgeDefinedField = (BridgeDefinedField)propertyMetadata.getBridgeDefinedFields().get(projectedField);
                if (bridgeDefinedField == null || !bridgeDefinedField.getName().equals(projectedField)) continue;
                return true;
            }
            return false;
        }

        private Object convertFieldValue(EntityIndexBinding binding, DocumentFieldMetadata field, JsonElement value) {
            FieldBridge fieldBridge = field.getFieldBridge();
            if (FieldHelper.isBoolean(binding, field.getName())) {
                return value.getAsBoolean();
            }
            if (fieldBridge instanceof TwoWayFieldBridge) {
                Document tmp = new Document();
                if (FieldHelper.isNumeric(field)) {
                    NumericFieldSettingsDescriptor.NumericEncodingType numericEncodingType = FieldHelper.getNumericEncodingType(binding, field);
                    switch (numericEncodingType) {
                        case INTEGER: {
                            tmp.add((IndexableField)new IntField(field.getName(), value.getAsInt(), Field.Store.NO));
                            break;
                        }
                        case LONG: {
                            tmp.add((IndexableField)new LongField(field.getName(), value.getAsLong(), Field.Store.NO));
                            break;
                        }
                        case FLOAT: {
                            tmp.add((IndexableField)new FloatField(field.getName(), value.getAsFloat(), Field.Store.NO));
                            break;
                        }
                        case DOUBLE: {
                            tmp.add((IndexableField)new DoubleField(field.getName(), value.getAsDouble(), Field.Store.NO));
                            break;
                        }
                        default: {
                            throw LOG.unexpectedNumericEncodingType(binding.getDocumentBuilder().getMetadata().getType().getName(), field.getName());
                        }
                    }
                } else {
                    tmp.add((IndexableField)new StringField(field.getName(), value.getAsString(), Field.Store.NO));
                }
                return ((TwoWayFieldBridge)fieldBridge).get(field.getName(), tmp);
            }
            return this.convertPrimitiveValue(value);
        }

        private Object convertPrimitiveValue(JsonElement value) {
            if (!value.isJsonPrimitive()) {
                throw LOG.unsupportedProjectionOfNonJsonPrimitiveFields(value);
            }
            JsonPrimitive primitive = value.getAsJsonPrimitive();
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            return primitive.toString();
        }

        private JsonElement getFieldValue(JsonObject parent, String projectedField) {
            String field = projectedField;
            if (FieldHelper.isEmbeddedField(projectedField)) {
                String[] parts = DOT.split(projectedField);
                field = parts[parts.length - 1];
                for (int i = 0; i < parts.length - 1; ++i) {
                    JsonElement newParent = parent.get(parts[i]);
                    if (newParent == null) {
                        return null;
                    }
                    parent = newParent.getAsJsonObject();
                }
            }
            return parent.getAsJsonObject().get(field);
        }
    }
}

