/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.builtin;

import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.builtin.impl.DateResolutionUtil;
import org.hibernate.search.bridge.spi.IgnoreAnalyzerBridge;

public class NumericEncodingDateBridge
implements TwoWayFieldBridge,
ParameterizedBridge,
IgnoreAnalyzerBridge {
    public static final TwoWayFieldBridge DATE_YEAR = new NumericEncodingDateBridge(Resolution.YEAR);
    public static final TwoWayFieldBridge DATE_MONTH = new NumericEncodingDateBridge(Resolution.MONTH);
    public static final TwoWayFieldBridge DATE_DAY = new NumericEncodingDateBridge(Resolution.DAY);
    public static final TwoWayFieldBridge DATE_HOUR = new NumericEncodingDateBridge(Resolution.HOUR);
    public static final TwoWayFieldBridge DATE_MINUTE = new NumericEncodingDateBridge(Resolution.MINUTE);
    public static final TwoWayFieldBridge DATE_SECOND = new NumericEncodingDateBridge(Resolution.SECOND);
    public static final TwoWayFieldBridge DATE_MILLISECOND = new NumericEncodingDateBridge(Resolution.MILLISECOND);
    private DateTools.Resolution resolution;

    public NumericEncodingDateBridge() {
        this(Resolution.MILLISECOND);
    }

    public NumericEncodingDateBridge(Resolution resolution) {
        this.resolution = DateResolutionUtil.getLuceneResolution(resolution);
    }

    @Override
    public Object get(String name, Document document) {
        IndexableField field = document.getField(name);
        if (field != null) {
            return new Date((Long)field.numericValue());
        }
        return null;
    }

    @Override
    public String objectToString(Object object) {
        return object != null ? Long.toString(((Date)object).getTime()) : null;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value == null) {
            return;
        }
        Date date = (Date)value;
        long numericDate = DateTools.round((long)date.getTime(), (DateTools.Resolution)this.resolution);
        luceneOptions.addNumericFieldToDocument(name, numericDate, document);
    }

    @Override
    public void setParameterValues(Map<String, String> parameters) {
        String resolution = parameters.get("resolution");
        Resolution hibResolution = Resolution.valueOf(resolution.toUpperCase(Locale.ENGLISH));
        this.resolution = DateResolutionUtil.getLuceneResolution(hibResolution);
    }

    public DateTools.Resolution getResolution() {
        return this.resolution;
    }
}

