/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.NestingMarker;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.nesting.impl.NestingContext;
import org.hibernate.search.engine.nesting.impl.NestingContextFactory;
import org.hibernate.search.engine.nesting.impl.NestingContextFactoryProvider;
import org.hibernate.search.engine.nesting.impl.NoOpNestingContext;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.impl.CollectionHelper;

public class ElasticsearchNestingContextFactoryProvider
implements NestingContextFactoryProvider,
Startable {
    private ElasticsearchNestingContextFactory factory;

    public void start(Properties properties, BuildContext context) {
        this.factory = new ElasticsearchNestingContextFactory(context.getUninitializedSearchIntegrator());
    }

    public NestingContextFactory getNestingContextFactory() {
        return this.factory;
    }

    private static final class NestingMarkerField
    extends MarkerField
    implements NestingMarker {
        private final List<NestingMarker.NestingPathComponent> nestingPath;

        public NestingMarkerField(List<NestingMarker.NestingPathComponent> nestingPath) {
            this.nestingPath = nestingPath;
        }

        @Override
        public List<NestingMarker.NestingPathComponent> getPath() {
            return this.nestingPath;
        }

        public String toString() {
            return "<ES nesting marker: " + this.nestingPath.toString() + ">";
        }
    }

    private static abstract class MarkerField
    extends Field {
        public MarkerField() {
            super("", new FieldType());
        }
    }

    private static class NestingStackElement
    implements NestingMarker.NestingPathComponent,
    Cloneable {
        private final EmbeddedTypeMetadata embeddedTypeMetadata;
        private final Integer index;

        public NestingStackElement(EmbeddedTypeMetadata embeddedTypeMetadata, Integer index) {
            this.embeddedTypeMetadata = embeddedTypeMetadata;
            this.index = index;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.embeddedTypeMetadata.getEmbeddedPropertyName());
            if (this.index != null) {
                builder.append("[").append(this.index).append("]");
            }
            builder.append(" => ").append(this.embeddedTypeMetadata.getEmbeddedFieldPrefix());
            return builder.toString();
        }

        public NestingStackElement createNext() {
            return new NestingStackElement(this.embeddedTypeMetadata, this.index + 1);
        }

        @Override
        public EmbeddedTypeMetadata getEmbeddedTypeMetadata() {
            return this.embeddedTypeMetadata;
        }

        @Override
        public Integer getIndex() {
            return this.index;
        }
    }

    private static class ElasticsearchNestingContext
    implements NestingContext {
        private Deque<NestingStackElement> path = new ArrayDeque<NestingStackElement>();

        private ElasticsearchNestingContext() {
        }

        public void push(EmbeddedTypeMetadata embeddedTypeMetadata) {
            this.path.addLast(new NestingStackElement(embeddedTypeMetadata, embeddedTypeMetadata.getEmbeddedContainer() == EmbeddedTypeMetadata.Container.OBJECT ? null : Integer.valueOf(0)));
        }

        public void mark(Document document) {
            List currentPath = CollectionHelper.toImmutableList(this.path);
            document.add((IndexableField)new NestingMarkerField(currentPath));
        }

        public void incrementCollectionIndex() {
            NestingStackElement current = this.path.removeLast();
            this.path.addLast(current.createNext());
        }

        public void pop() {
            this.path.removeLast();
        }
    }

    private static enum ContextCreationStrategy {
        NO_OP{

            @Override
            NestingContext create() {
                return NoOpNestingContext.INSTANCE;
            }
        }
        ,
        ES{

            @Override
            NestingContext create() {
                return new ElasticsearchNestingContext();
            }
        };


        abstract NestingContext create();
    }

    private static class ElasticsearchNestingContextFactory
    implements NestingContextFactory {
        private final ConcurrentMap<String, ContextCreationStrategy> strategies = new ConcurrentHashMap<String, ContextCreationStrategy>();
        private ExtendedSearchIntegrator searchIntegrator;

        public ElasticsearchNestingContextFactory(ExtendedSearchIntegrator searchIntegrator) {
            this.searchIntegrator = searchIntegrator;
        }

        public NestingContext createNestingContext(Class<?> indexedEntityType) {
            ContextCreationStrategy strategy = (ContextCreationStrategy)((Object)this.strategies.get(indexedEntityType.getName()));
            if (strategy == null) {
                strategy = this.isMappedToElasticsearch(indexedEntityType) ? ContextCreationStrategy.ES : ContextCreationStrategy.NO_OP;
                this.strategies.putIfAbsent(indexedEntityType.getName(), strategy);
            }
            return strategy.create();
        }

        private boolean isMappedToElasticsearch(Class<?> entityType) {
            Set queriedEntityTypesWithSubTypes = this.searchIntegrator.getIndexedTypesPolymorphic(new Class[]{entityType});
            for (Class queriedEntityType : queriedEntityTypesWithSubTypes) {
                IndexManager[] indexManagers;
                EntityIndexBinding binding = this.searchIntegrator.getIndexBinding(queriedEntityType);
                for (IndexManager indexManager : indexManagers = binding.getIndexManagers()) {
                    if (!(indexManager instanceof ElasticsearchIndexManager)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

