/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchValidationMessages;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.ValidationContext;
import org.hibernate.search.elasticsearch.schema.impl.ValidationErrorCollector;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.DynamicType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.StringHelper;
import org.hibernate.search.util.impl.CollectionHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.jboss.logging.Messages;

public class DefaultElasticsearchSchemaValidator
implements ElasticsearchSchemaValidator,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final ElasticsearchValidationMessages MESSAGES = (ElasticsearchValidationMessages)Messages.getBundle(ElasticsearchValidationMessages.class);
    private static final double DEFAULT_DOUBLE_DELTA = 0.001;
    private static final float DEFAULT_FLOAT_DELTA = 0.001f;
    private static final List<String> DEFAULT_DATE_FORMAT;
    private ServiceManager serviceManager;
    private ElasticsearchSchemaAccessor schemaAccessor;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.schemaAccessor = (ElasticsearchSchemaAccessor)this.serviceManager.requestService(ElasticsearchSchemaAccessor.class);
    }

    public void stop() {
        this.schemaAccessor = null;
        this.serviceManager.releaseService(ElasticsearchSchemaAccessor.class);
        this.serviceManager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validate(IndexMetadata expectedIndexMetadata, ExecutionOptions executionOptions) {
        String indexName = expectedIndexMetadata.getName();
        IndexMetadata actualIndexMetadata = this.schemaAccessor.getCurrentIndexMetadata(indexName);
        ValidationErrorCollector errorCollector = new ValidationErrorCollector();
        errorCollector.setIndexName(indexName);
        try {
            this.validate(errorCollector, expectedIndexMetadata, actualIndexMetadata);
        }
        finally {
            errorCollector.setIndexName(null);
        }
        Map<ValidationContext, List<String>> messagesByContext = errorCollector.getMessagesByContext();
        if (messagesByContext.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<ValidationContext, List<String>> entry : messagesByContext.entrySet()) {
            ValidationContext context = entry.getKey();
            List<String> messages = entry.getValue();
            builder.append("\n").append(this.formatIntro(context));
            for (String message : messages) {
                builder.append("\n\t").append(message);
            }
        }
        throw LOG.schemaValidationFailed(builder.toString());
    }

    private Object formatIntro(ValidationContext context) {
        if (StringHelper.isNotEmpty((String)context.getFieldName())) {
            return MESSAGES.errorIntro(context.getIndexName(), context.getMappingName(), context.getPath(), context.getFieldName());
        }
        if (StringHelper.isNotEmpty((String)context.getPath())) {
            return MESSAGES.errorIntro(context.getIndexName(), context.getMappingName(), context.getPath());
        }
        if (StringHelper.isNotEmpty((String)context.getMappingName())) {
            return MESSAGES.errorIntro(context.getIndexName(), context.getMappingName());
        }
        return MESSAGES.errorIntro(context.getIndexName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(ValidationErrorCollector errorCollector, IndexMetadata expectedIndexMetadata, IndexMetadata actualIndexMetadata) {
        for (Map.Entry<String, TypeMapping> entry : expectedIndexMetadata.getMappings().entrySet()) {
            String mappingName = entry.getKey();
            TypeMapping expectedTypeMapping = entry.getValue();
            TypeMapping actualTypeMapping = actualIndexMetadata.getMappings().get(mappingName);
            errorCollector.setMappingName(mappingName);
            try {
                if (actualTypeMapping == null) {
                    errorCollector.addError(MESSAGES.mappingMissing());
                    continue;
                }
                this.validateTypeMapping(errorCollector, expectedTypeMapping, actualTypeMapping);
            }
            finally {
                errorCollector.setMappingName(null);
            }
        }
    }

    private void validateTypeMapping(ValidationErrorCollector errorCollector, TypeMapping expectedMapping, TypeMapping actualMapping) {
        DynamicType expectedDynamic = expectedMapping.getDynamic();
        if (expectedDynamic != null) {
            DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "dynamic", expectedDynamic, actualMapping.getDynamic(), DynamicType.TRUE);
        }
        this.validateTypeMappingProperties(errorCollector, expectedMapping, actualMapping);
    }

    private static <T> void validateEqualWithDefault(ValidationErrorCollector errorCollector, String attributeName, T expectedValue, T actualValue, T defaultValueForNulls) {
        T defaultedActualValue;
        T defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        T t = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (!Objects.equals(defaultedExpectedValue, defaultedActualValue)) {
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        }
    }

    private static <T> void validateEqualWithDefault(ValidationErrorCollector errorCollector, String attributeName, Float expectedValue, Float actualValue, float delta, Float defaultValueForNulls) {
        Float defaultedActualValue;
        Float defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        Float f = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (defaultedExpectedValue == null || defaultedActualValue == null) {
            if (defaultedExpectedValue == defaultedActualValue) {
                return;
            }
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        } else {
            if (Float.compare(defaultedExpectedValue.floatValue(), defaultedActualValue.floatValue()) == 0) {
                return;
            }
            if (Math.abs(defaultedExpectedValue.floatValue() - defaultedActualValue.floatValue()) > delta) {
                errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
            }
        }
    }

    private static <T> void validateEqualWithDefault(ValidationErrorCollector errorCollector, String attributeName, Double expectedValue, Double actualValue, double delta, Double defaultValueForNulls) {
        Double defaultedActualValue;
        Double defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        Double d = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (defaultedExpectedValue == null || defaultedActualValue == null) {
            if (defaultedExpectedValue == defaultedActualValue) {
                return;
            }
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        }
        if (Double.compare(defaultedExpectedValue, defaultedActualValue) == 0) {
            return;
        }
        if (Math.abs(defaultedExpectedValue - defaultedActualValue) > delta) {
            errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, defaultedExpectedValue, actualValue));
        }
    }

    private static <T> void validateFormatWithDefault(ValidationErrorCollector errorCollector, String attributeName, List<String> expectedValue, List<String> actualValue, List<String> defaultValueForNulls) {
        String actualOutputFormat;
        List<String> defaultedActualValue;
        List<String> defaultedExpectedValue = expectedValue == null ? defaultValueForNulls : expectedValue;
        List<String> list = defaultedActualValue = actualValue == null ? defaultValueForNulls : actualValue;
        if (defaultedExpectedValue.isEmpty()) {
            return;
        }
        String expectedOutputFormat = defaultedExpectedValue.get(0);
        String string = actualOutputFormat = defaultedActualValue.isEmpty() ? null : defaultedActualValue.get(0);
        if (!Objects.equals(expectedOutputFormat, actualOutputFormat)) {
            errorCollector.addError(MESSAGES.invalidOutputFormat(attributeName, expectedOutputFormat, actualOutputFormat));
        }
        ArrayList<String> missingFormats = new ArrayList<String>();
        missingFormats.addAll(defaultedExpectedValue);
        missingFormats.removeAll(defaultedActualValue);
        ArrayList<String> unexpectedFormats = new ArrayList<String>();
        unexpectedFormats.addAll(defaultedActualValue);
        unexpectedFormats.removeAll(defaultedExpectedValue);
        if (!missingFormats.isEmpty() || !unexpectedFormats.isEmpty()) {
            errorCollector.addError(MESSAGES.invalidInputFormat(attributeName, defaultedExpectedValue, defaultedActualValue, missingFormats, unexpectedFormats));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateTypeMappingProperties(ValidationErrorCollector errorCollector, TypeMapping expectedMapping, TypeMapping actualMapping) {
        Map<String, PropertyMapping> expectedPropertyMappings = expectedMapping.getProperties();
        Map<String, PropertyMapping> actualPropertyMappings = actualMapping.getProperties();
        if (expectedPropertyMappings != null) {
            for (Map.Entry<String, PropertyMapping> entry : expectedPropertyMappings.entrySet()) {
                String propertyName = entry.getKey();
                PropertyMapping expectedPropertyMapping = entry.getValue();
                PropertyMapping actualPropertyMapping = actualPropertyMappings == null ? null : actualPropertyMappings.get(propertyName);
                errorCollector.pushPropertyName(propertyName);
                try {
                    if (actualPropertyMapping == null) {
                        errorCollector.addError(MESSAGES.propertyMissing());
                        continue;
                    }
                    this.validatePropertyMapping(errorCollector, expectedPropertyMapping, actualPropertyMapping);
                }
                finally {
                    errorCollector.popPropertyName();
                }
            }
        }
    }

    private void validatePropertyMapping(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        Boolean expectedStore;
        Boolean expectedDocValues;
        DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "type", expectedMapping.getType(), actualMapping.getType(), DataType.OBJECT);
        List<String> formatDefault = DataType.DATE.equals((Object)expectedMapping.getType()) ? DEFAULT_DATE_FORMAT : Collections.emptyList();
        DefaultElasticsearchSchemaValidator.validateFormatWithDefault(errorCollector, "format", expectedMapping.getFormat(), actualMapping.getFormat(), formatDefault);
        DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "boost", expectedMapping.getBoost(), actualMapping.getBoost(), 0.001f, Float.valueOf(1.0f));
        IndexType expectedIndex = expectedMapping.getIndex();
        if (!IndexType.NO.equals((Object)expectedIndex)) {
            IndexType indexDefault = DataType.STRING.equals((Object)expectedMapping.getType()) ? IndexType.ANALYZED : IndexType.NOT_ANALYZED;
            DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "index", expectedIndex, actualMapping.getIndex(), indexDefault);
        }
        if (Boolean.TRUE.equals(expectedDocValues = expectedMapping.getDocValues())) {
            DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "doc_values", expectedDocValues, actualMapping.getDocValues(), false);
        }
        if (Boolean.TRUE.equals(expectedStore = expectedMapping.getStore())) {
            DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "store", expectedStore, actualMapping.getStore(), false);
        }
        DefaultElasticsearchSchemaValidator.validateJsonPrimitive(errorCollector, expectedMapping.getType(), "null_value", expectedMapping.getNullValue(), actualMapping.getNullValue());
        DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, "analyzer", expectedMapping.getAnalyzer(), actualMapping.getAnalyzer(), null);
        this.validateTypeMapping(errorCollector, expectedMapping, actualMapping);
        this.validatePropertyMappingFields(errorCollector, expectedMapping, actualMapping);
    }

    private void validatePropertyMappingFields(ValidationErrorCollector errorCollector, PropertyMapping expectedMapping, PropertyMapping actualMapping) {
        Map<String, PropertyMapping> expectedFieldMappings = expectedMapping.getFields();
        Map<String, PropertyMapping> actualFieldMappings = actualMapping.getFields();
        if (expectedFieldMappings != null) {
            for (Map.Entry<String, PropertyMapping> entry : expectedFieldMappings.entrySet()) {
                String fieldName = entry.getKey();
                PropertyMapping expectedFieldMapping = entry.getValue();
                PropertyMapping actualFieldMapping = actualFieldMappings == null ? null : actualFieldMappings.get(fieldName);
                errorCollector.setFieldName(fieldName);
                try {
                    if (actualFieldMapping == null) {
                        errorCollector.addError(MESSAGES.propertyFieldMissing());
                        continue;
                    }
                    this.validatePropertyMapping(errorCollector, expectedFieldMapping, actualFieldMapping);
                }
                catch (ElasticsearchSchemaValidationException e) {
                    errorCollector.setFieldName(null);
                }
            }
        }
    }

    private static void validateJsonPrimitive(ValidationErrorCollector errorCollector, DataType type, String attributeName, JsonPrimitive expectedValue, JsonPrimitive actualValue) {
        DataType defaultedType = type == null ? DataType.OBJECT : type;
        switch (defaultedType) {
            case DOUBLE: {
                if (expectedValue.isNumber() && actualValue.isNumber()) {
                    DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, attributeName, expectedValue.getAsDouble(), actualValue.getAsDouble(), 0.001, null);
                    break;
                }
                errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, expectedValue, actualValue));
                break;
            }
            case FLOAT: {
                if (expectedValue.isNumber() && actualValue.isNumber()) {
                    DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, attributeName, Float.valueOf(expectedValue.getAsFloat()), Float.valueOf(actualValue.getAsFloat()), 0.001f, null);
                    break;
                }
                errorCollector.addError(MESSAGES.invalidAttributeValue(attributeName, expectedValue, actualValue));
                break;
            }
            default: {
                DefaultElasticsearchSchemaValidator.validateEqualWithDefault(errorCollector, attributeName, expectedValue, actualValue, null);
            }
        }
    }

    static {
        ArrayList<String> formats = new ArrayList<String>();
        formats.add("strict_date_optional_time");
        formats.add("epoch_millis");
        DEFAULT_DATE_FORMAT = CollectionHelper.toImmutableList(formats);
    }
}

