/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import io.searchbox.action.AbstractAction;
import io.searchbox.cluster.Health;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.DeleteIndex;
import io.searchbox.indices.IndicesExists;
import io.searchbox.indices.mapping.GetMapping;
import io.searchbox.indices.mapping.PutMapping;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Properties;
import org.hibernate.search.elasticsearch.client.impl.JestClient;
import org.hibernate.search.elasticsearch.impl.GsonService;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.engine.service.spi.Service;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ElasticsearchSchemaAccessor
implements Service,
Startable,
Stoppable {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private static final TypeToken<Map<String, TypeMapping>> STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN = new TypeToken<Map<String, TypeMapping>>(){};
    private ServiceManager serviceManager;
    private JestClient jestClient;
    private GsonService gsonService;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.jestClient = (JestClient)this.serviceManager.requestService(JestClient.class);
        this.gsonService = (GsonService)this.serviceManager.requestService(GsonService.class);
    }

    public void stop() {
        this.jestClient = null;
        this.serviceManager.releaseService(JestClient.class);
        this.gsonService = null;
        this.serviceManager.releaseService(GsonService.class);
        this.serviceManager = null;
    }

    public void createIndex(String indexName, ExecutionOptions executionOptions) {
        CreateIndex createIndex = new CreateIndex.Builder(indexName).build();
        this.jestClient.executeRequest(createIndex);
    }

    public boolean createIndexIfAbsent(String indexName, ExecutionOptions executionOptions) {
        Object result = this.jestClient.executeRequest(new CreateIndex.Builder(indexName).build(), new String[]{"index_already_exists_exception"});
        return result.isSucceeded();
    }

    public boolean indexExists(String indexName) {
        Object peekResult = this.jestClient.executeRequest(new IndicesExists.Builder(indexName).build(), new int[]{404});
        return peekResult.getResponseCode() == 200;
    }

    public IndexMetadata getCurrentIndexMetadata(String indexName) {
        GetMapping getMapping = ((GetMapping.Builder)new GetMapping.Builder().addIndex(indexName)).build();
        try {
            Object result = this.jestClient.executeRequest(getMapping);
            JsonObject resultJson = result.getJsonObject();
            JsonElement index = result.getJsonObject().get(indexName);
            if (index == null || !index.isJsonObject()) {
                throw new AssertionFailure("Elasticsearch API call succeeded, but the requested index wasn't mentioned in the result: " + resultJson);
            }
            JsonElement mappings = index.getAsJsonObject().get("mappings");
            IndexMetadata indexMetadata = new IndexMetadata();
            indexMetadata.setName(indexName);
            if (mappings != null) {
                Type mapType = STRING_TO_TYPE_MAPPING_MAP_TYPE_TOKEN.getType();
                indexMetadata.setMappings((Map)this.gsonService.getGson().fromJson(mappings, mapType));
            }
            return indexMetadata;
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchMappingRetrievalForValidationFailed(e);
        }
    }

    public void putMapping(String indexName, String mappingName, TypeMapping mapping) {
        Gson gson = this.gsonService.getGsonNoSerializeNulls();
        String mappingAsJson = gson.toJson((Object)mapping);
        PutMapping putMapping = new PutMapping.Builder(indexName, mappingName, (Object)mappingAsJson).build();
        try {
            this.jestClient.executeRequest(putMapping);
        }
        catch (RuntimeException e) {
            throw LOG.elasticsearchMappingCreationFailed(mappingName, e);
        }
    }

    public void waitForIndexStatus(final String theIndexName, ExecutionOptions executionOptions) {
        String requiredIndexStatusString = executionOptions.getRequiredIndexStatus().getElasticsearchString();
        Health.Builder healthBuilder = (Health.Builder)((Health.Builder)new Health.Builder().setParameter("wait_for_status", (Object)requiredIndexStatusString)).setParameter("timeout", (Object)(executionOptions.getIndexManagementTimeoutInMs() + "ms"));
        Health health = new Health(healthBuilder){

            protected String buildURI() {
                try {
                    return super.buildURI() + URLEncoder.encode(theIndexName, AbstractAction.CHARSET);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionFailure("Unexpectedly unsupported charset", (Throwable)e);
                }
            }
        };
        Object result = this.jestClient.executeRequest(health, new int[]{408});
        if (!result.isSucceeded()) {
            String status = result.getJsonObject().get("status").getAsString();
            throw LOG.unexpectedIndexStatus(theIndexName, requiredIndexStatusString, status);
        }
    }

    public void dropIndex(String indexName, ExecutionOptions executionOptions) {
        this.jestClient.executeRequest(new DeleteIndex.Builder(indexName).build());
    }
}

