/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.PropertyMapping;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.util.impl.ParentPathMismatchException;
import org.hibernate.search.elasticsearch.util.impl.PathComponentExtractor;
import org.hibernate.search.engine.metadata.impl.EmbeddedTypeMetadata;
import org.hibernate.search.engine.metadata.impl.TypeMetadata;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.util.logging.impl.LoggerFactory;

final class ElasticsearchMappingBuilder {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final EntityIndexBinding binding;
    private final ElasticsearchMappingBuilder parent;
    private final TypeMetadata typeMetadata;
    private final PathComponentExtractor pathComponentExtractor;
    private TypeMapping elasticsearchMapping;

    public ElasticsearchMappingBuilder(EntityIndexBinding binding, TypeMapping elasticsearchMapping) {
        this.binding = binding;
        this.parent = null;
        this.typeMetadata = binding.getDocumentBuilder().getTypeMetadata();
        this.pathComponentExtractor = new PathComponentExtractor();
        this.elasticsearchMapping = elasticsearchMapping;
    }

    public ElasticsearchMappingBuilder(ElasticsearchMappingBuilder parent, EmbeddedTypeMetadata embeddedTypeMetadata) {
        this.binding = parent.binding;
        this.parent = parent;
        this.typeMetadata = embeddedTypeMetadata;
        this.pathComponentExtractor = parent.clonePathExtractor();
        this.pathComponentExtractor.append(embeddedTypeMetadata.getEmbeddedFieldPrefix());
        this.elasticsearchMapping = null;
    }

    private TypeMapping getOrCreateParents(PathComponentExtractor extractor) {
        if (this.elasticsearchMapping == null) {
            this.elasticsearchMapping = this.parent.getOrCreateParents(this.pathComponentExtractor);
        }
        TypeMapping currentElasticsearchMapping = this.elasticsearchMapping;
        String newPathComponent = extractor.next(PathComponentExtractor.ConsumptionLimit.SECOND_BUT_LAST);
        while (newPathComponent != null) {
            PropertyMapping childPropertyMapping = ElasticsearchMappingBuilder.getPropertyRelative(currentElasticsearchMapping, newPathComponent);
            if (childPropertyMapping == null) {
                childPropertyMapping = new PropertyMapping();
                childPropertyMapping.setType(DataType.OBJECT);
                currentElasticsearchMapping.addProperty(newPathComponent, childPropertyMapping);
            }
            if (!DataType.OBJECT.equals((Object)childPropertyMapping.getType())) {
                throw LOG.fieldIsBothCompositeAndConcrete(this.getBeanClass(), extractor.getLastComponentAbsolutePath());
            }
            currentElasticsearchMapping = childPropertyMapping;
            newPathComponent = extractor.next(PathComponentExtractor.ConsumptionLimit.SECOND_BUT_LAST);
        }
        return currentElasticsearchMapping;
    }

    private static PropertyMapping getPropertyRelative(TypeMapping parent, String name) {
        Map<String, PropertyMapping> properties = parent.getProperties();
        if (properties == null) {
            return null;
        }
        return properties.get(name);
    }

    public boolean hasPropertyAbsolute(String absolutePath) {
        return this.getPropertyAbsolute(absolutePath) != null;
    }

    public TypeMapping getPropertyAbsolute(String absolutePath) {
        PathComponentExtractor newExtractor = this.createPathExtractorForAbsolutePath(absolutePath);
        TypeMapping currentMapping = this.elasticsearchMapping;
        String pathComponent = newExtractor.next(PathComponentExtractor.ConsumptionLimit.LAST);
        while (currentMapping != null && pathComponent != null) {
            currentMapping = ElasticsearchMappingBuilder.getPropertyRelative(currentMapping, pathComponent);
            pathComponent = newExtractor.next(PathComponentExtractor.ConsumptionLimit.LAST);
        }
        return currentMapping;
    }

    public void setPropertyAbsolute(String absolutePath, PropertyMapping propertyMapping) {
        PathComponentExtractor newExtractor = this.createPathExtractorForAbsolutePath(absolutePath);
        TypeMapping parent = this.getOrCreateParents(newExtractor);
        String propertyName = newExtractor.next(PathComponentExtractor.ConsumptionLimit.LAST);
        Map<String, PropertyMapping> parentProperties = parent.getProperties();
        if (parentProperties != null && parentProperties.containsKey(propertyName)) {
            PropertyMapping conflictingProperty = parentProperties.get(propertyName);
            DataType conflictingPropertyType = conflictingProperty.getType();
            DataType newPropertyType = propertyMapping.getType();
            if (conflictingPropertyType.isComposite() != newPropertyType.isComposite()) {
                throw LOG.fieldIsBothCompositeAndConcrete(this.getBeanClass(), absolutePath);
            }
        }
        parent.addProperty(propertyName, propertyMapping);
    }

    private PathComponentExtractor clonePathExtractor() {
        PathComponentExtractor newExtractor = this.pathComponentExtractor.clone();
        newExtractor.flushTo(PathComponentExtractor.ConsumptionLimit.SECOND_BUT_LAST);
        return newExtractor;
    }

    private PathComponentExtractor createPathExtractorForAbsolutePath(String absolutePath) {
        try {
            PathComponentExtractor newExtractor = this.clonePathExtractor();
            newExtractor.appendRelativePart(absolutePath);
            return newExtractor;
        }
        catch (ParentPathMismatchException e) {
            throw LOG.indexedEmbeddedPrefixBypass(this.getBeanClass(), e.getMismatchingPath(), e.getExpectedParentPath());
        }
    }

    public TypeMetadata getMetadata() {
        return this.typeMetadata;
    }

    public float getBoost(Float propertyBoost) {
        float boost = propertyBoost == null ? 1.0f : propertyBoost.floatValue();
        boost *= this.typeMetadata.getStaticBoost();
        if (this.parent != null) {
            return this.parent.getBoost(Float.valueOf(boost));
        }
        return boost;
    }

    public Class<?> getBeanClass() {
        return this.binding.getDocumentBuilder().getBeanClass();
    }
}

